package com.diaoyun.zion;


import com.alibaba.fastjson.JSON;
import com.diaoyun.zion.chinafrica.vo.Products;
import com.diaoyun.zion.chinafrica.vo.ShopifyConstant;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.ListUtil;
import com.github.pagehelper.PageInfo;
import com.google.gson.JsonArray;
import io.swagger.models.auth.In;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.junit.Test;
import springfox.documentation.spring.web.json.Json;

import java.io.IOException;
import java.util.*;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 微信
 *
 * @author egan
 * @email egzosn@gmail.com
 * @date 2017/8/18
 */
public class PayTest {

    @Test
    public void test() throws IOException {
        Map<String, Object> params = new HashMap<>();
        params.put("fields", "product_type");
        String connection = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
        List list = new ArrayList();
        JSONArray products = JSONObject.fromObject(connection).getJSONArray("products");
        for (int i = 0; i < products.size(); i++) {
            String string = products.getString(i);
            JSONObject jsonObject = JSONObject.fromObject(string);
            String product_type = jsonObject.getString("product_type");
            if (!"".equals(product_type) && !list.contains(product_type)) {
                list.add(product_type);
            }
        }
        System.out.println(list);

    }

    @Test
    public void test1() throws IOException {
        Result result = new Result();
        Map<String, Object> params = new HashMap<>();
        params.put("product_type", "Christmas");
        params.put("limit","1");
        //params.put("since_id", "4248995594337");
        List list = new ArrayList<>();

        String data = HttpClientUtil.createConnection(ShopifyConstant.productTypeUrl(), params, "UTF-8");
        JSONArray products = JSONObject.fromObject(data).getJSONArray("products");
        for (int i=0;i<products.size();i++){
            Products product = JSON.parseObject(data, Products.class);
            System.out.println(products);
        }
    }

    @Test
    public void test3() {
        Integer count = 0;
        while (count < 4) {
            System.out.println("helloworld!");
            count++;
        }
    }

    @Test
    public void testJson() {
        String str = "{\"products\":[{\"id\":4286830706785,\"title\":\"Black sneakers\",\"body_html\":\"\",\"vendor\":\"东泽阿玛尼\",\"product_type\":\"Men\",\"created_at\":\"2019-10-18T17:00:05+08:00\",\"handle\":\"black-sneakers\",\"updated_at\":\"2019-10-21T10:02:50+08:00\",\"published_at\":\"2019-10-18T16:56:43+08:00\",\"template_suffix\":null,\"tags\":\"Men Casual shoes\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4286830706785\",\"variants\":[{\"id\":30880643776609,\"product_id\":4286830706785,\"title\":\"38\",\"price\":\"23.99\",\"sku\":\"\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"38\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:00:06+08:00\",\"updated_at\":\"2019-10-21T10:02:49+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":0,\"image_id\":null,\"weight\":0.0,\"weight_unit\":\"kg\",\"inventory_item_id\":32293977129057,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880643776609\"},{\"id\":30880643809377,\"product_id\":4286830706785,\"title\":\"39\",\"price\":\"23.99\",\"sku\":\"\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"39\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:00:06+08:00\",\"updated_at\":\"2019-10-21T10:02:50+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":0,\"image_id\":null,\"weight\":0.0,\"weight_unit\":\"kg\",\"inventory_item_id\":32293977161825,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880643809377\"},{\"id\":30880643842145,\"product_id\":4286830706785,\"title\":\"40\",\"price\":\"23.99\",\"sku\":\"\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"40\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:00:06+08:00\",\"updated_at\":\"2019-10-21T10:02:50+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":0,\"image_id\":null,\"weight\":0.0,\"weight_unit\":\"kg\",\"inventory_item_id\":32293977194593,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880643842145\"},{\"id\":30880643874913,\"product_id\":4286830706785,\"title\":\"41\",\"price\":\"23.99\",\"sku\":\"\",\"position\":4,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"41\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:00:06+08:00\",\"updated_at\":\"2019-10-21T10:02:50+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":0,\"image_id\":null,\"weight\":0.0,\"weight_unit\":\"kg\",\"inventory_item_id\":32293977227361,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880643874913\"},{\"id\":30880643907681,\"product_id\":4286830706785,\"title\":\"42\",\"price\":\"23.99\",\"sku\":\"\",\"position\":5,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"42\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:00:06+08:00\",\"updated_at\":\"2019-10-21T10:02:50+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":0,\"image_id\":null,\"weight\":0.0,\"weight_unit\":\"kg\",\"inventory_item_id\":32293977260129,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880643907681\"},{\"id\":30880643940449,\"product_id\":4286830706785,\"title\":\"43\",\"price\":\"23.99\",\"sku\":\"\",\"position\":6,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"43\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:00:06+08:00\",\"updated_at\":\"2019-10-21T10:02:50+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":0,\"image_id\":null,\"weight\":0.0,\"weight_unit\":\"kg\",\"inventory_item_id\":32293977292897,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880643940449\"}],\"options\":[{\"id\":5574305546337,\"product_id\":4286830706785,\"name\":\"Size\",\"position\":1,\"values\":[\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]}],\"images\":[{\"id\":13214913626209,\"product_id\":4286830706785,\"position\":1,\"created_at\":\"2019-10-18T17:00:11+08:00\",\"updated_at\":\"2019-10-18T17:00:11+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/5f719703b7f164a66222139f208632e.jpg?v=1571389211\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214913626209\"},{\"id\":13214914674785,\"product_id\":4286830706785,\"position\":2,\"created_at\":\"2019-10-18T17:00:16+08:00\",\"updated_at\":\"2019-10-18T17:00:16+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/900cb5c599ac1e15346ae87cd49655b.jpg?v=1571389216\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214914674785\"},{\"id\":13214916313185,\"product_id\":4286830706785,\"position\":3,\"created_at\":\"2019-10-18T17:00:21+08:00\",\"updated_at\":\"2019-10-18T17:00:21+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/c5b1036cfa690e2c3643df504f0761d.jpg?v=1571389221\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214916313185\"}],\"image\":{\"id\":13214913626209,\"product_id\":4286830706785,\"position\":1,\"created_at\":\"2019-10-18T17:00:11+08:00\",\"updated_at\":\"2019-10-18T17:00:11+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/5f719703b7f164a66222139f208632e.jpg?v=1571389211\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214913626209\"}},{\"id\":4286850072673,\"title\":\"Black sneakers\",\"body_html\":\"\",\"vendor\":\"东泽阿玛尼\",\"product_type\":\"Men\",\"created_at\":\"2019-10-18T17:06:00+08:00\",\"handle\":\"black-sneakers-1\",\"updated_at\":\"2019-10-21T10:03:32+08:00\",\"published_at\":\"2019-10-18T17:03:28+08:00\",\"template_suffix\":null,\"tags\":\"Men Casual shoes\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4286850072673\",\"variants\":[{\"id\":30880695222369,\"product_id\":4286850072673,\"title\":\"38\",\"price\":\"23.99\",\"sku\":\"\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"38\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:06:00+08:00\",\"updated_at\":\"2019-10-21T10:03:31+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294038798433,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880695222369\"},{\"id\":30880695255137,\"product_id\":4286850072673,\"title\":\"39\",\"price\":\"23.99\",\"sku\":\"\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"39\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:06:00+08:00\",\"updated_at\":\"2019-10-21T10:03:31+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294038831201,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880695255137\"},{\"id\":30880695287905,\"product_id\":4286850072673,\"title\":\"40\",\"price\":\"23.99\",\"sku\":\"\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"40\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:06:00+08:00\",\"updated_at\":\"2019-10-21T10:03:31+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294038863969,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880695287905\"},{\"id\":30880695320673,\"product_id\":4286850072673,\"title\":\"41\",\"price\":\"23.99\",\"sku\":\"\",\"position\":4,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"41\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:06:00+08:00\",\"updated_at\":\"2019-10-21T10:03:32+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294038896737,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880695320673\"},{\"id\":30880695353441,\"product_id\":4286850072673,\"title\":\"42\",\"price\":\"23.99\",\"sku\":\"\",\"position\":5,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"42\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:06:00+08:00\",\"updated_at\":\"2019-10-21T10:03:32+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294038929505,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880695353441\"},{\"id\":30880695386209,\"product_id\":4286850072673,\"title\":\"43\",\"price\":\"23.99\",\"sku\":\"\",\"position\":6,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"43\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:06:00+08:00\",\"updated_at\":\"2019-10-21T10:03:32+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294038962273,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880695386209\"}],\"options\":[{\"id\":5574329106529,\"product_id\":4286850072673,\"name\":\"Size\",\"position\":1,\"values\":[\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]}],\"images\":[{\"id\":13214976573537,\"product_id\":4286850072673,\"position\":1,\"created_at\":\"2019-10-18T17:06:06+08:00\",\"updated_at\":\"2019-10-18T17:06:06+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/3e7e86d5ca21ed1a0dfa157bd1dc335.jpg?v=1571389566\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214976573537\"},{\"id\":13214978670689,\"product_id\":4286850072673,\"position\":2,\"created_at\":\"2019-10-18T17:06:12+08:00\",\"updated_at\":\"2019-10-18T17:06:12+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/0146f58ea73d83a98e69beaca19691f.jpg?v=1571389572\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214978670689\"},{\"id\":13214981062753,\"product_id\":4286850072673,\"position\":3,\"created_at\":\"2019-10-18T17:06:18+08:00\",\"updated_at\":\"2019-10-18T17:06:18+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/9215dc2a747da1d27f5f90d871631d0.jpg?v=1571389578\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214981062753\"}],\"image\":{\"id\":13214976573537,\"product_id\":4286850072673,\"position\":1,\"created_at\":\"2019-10-18T17:06:06+08:00\",\"updated_at\":\"2019-10-18T17:06:06+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/3e7e86d5ca21ed1a0dfa157bd1dc335.jpg?v=1571389566\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13214976573537\"}},{\"id\":4286861181025,\"title\":\"Black sneakers\",\"body_html\":\"\",\"vendor\":\"东泽阿玛尼\",\"product_type\":\"Men\",\"created_at\":\"2019-10-18T17:15:04+08:00\",\"handle\":\"black-sneakers-2\",\"updated_at\":\"2019-10-21T10:04:12+08:00\",\"published_at\":\"2019-10-18T17:09:01+08:00\",\"template_suffix\":null,\"tags\":\"Men Casual shoes\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4286861181025\",\"variants\":[{\"id\":30880773636193,\"product_id\":4286861181025,\"title\":\"38\",\"price\":\"23.99\",\"sku\":\"\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"38\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:15:05+08:00\",\"updated_at\":\"2019-10-21T10:04:11+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294132383841,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880773636193\"},{\"id\":30880773668961,\"product_id\":4286861181025,\"title\":\"39\",\"price\":\"23.99\",\"sku\":\"\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"39\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:15:05+08:00\",\"updated_at\":\"2019-10-21T10:04:12+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294132416609,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880773668961\"},{\"id\":30880773701729,\"product_id\":4286861181025,\"title\":\"40\",\"price\":\"23.99\",\"sku\":\"\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"40\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:15:05+08:00\",\"updated_at\":\"2019-10-21T10:04:12+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294132449377,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880773701729\"},{\"id\":30880773734497,\"product_id\":4286861181025,\"title\":\"41\",\"price\":\"23.99\",\"sku\":\"\",\"position\":4,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"41\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:15:05+08:00\",\"updated_at\":\"2019-10-21T10:04:12+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294132482145,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880773734497\"},{\"id\":30880773767265,\"product_id\":4286861181025,\"title\":\"42\",\"price\":\"23.99\",\"sku\":\"\",\"position\":5,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"42\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:15:05+08:00\",\"updated_at\":\"2019-10-21T10:04:12+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294132514913,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880773767265\"},{\"id\":30880773800033,\"product_id\":4286861181025,\"title\":\"43\",\"price\":\"23.99\",\"sku\":\"\",\"position\":6,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"43\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-10-18T17:15:05+08:00\",\"updated_at\":\"2019-10-21T10:04:12+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294132547681,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880773800033\"}],\"options\":[{\"id\":5574346702945,\"product_id\":4286861181025,\"name\":\"Size\",\"position\":1,\"values\":[\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]}],\"images\":[{\"id\":13215065407585,\"product_id\":4286861181025,\"position\":1,\"created_at\":\"2019-10-18T17:15:11+08:00\",\"updated_at\":\"2019-10-18T17:15:11+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/fe750728c67c923913c82951879771a.jpg?v=1571390111\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215065407585\"},{\"id\":13215066030177,\"product_id\":4286861181025,\"position\":2,\"created_at\":\"2019-10-18T17:15:17+08:00\",\"updated_at\":\"2019-10-18T17:15:17+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/4b7db43122cab7f3c17d5a51f3d0c90.jpg?v=1571390117\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215066030177\"}],\"image\":{\"id\":13215065407585,\"product_id\":4286861181025,\"position\":1,\"created_at\":\"2019-10-18T17:15:11+08:00\",\"updated_at\":\"2019-10-18T17:15:11+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/fe750728c67c923913c82951879771a.jpg?v=1571390111\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215065407585\"}},{\"id\":4349270261857,\"title\":\"Business backpack\",\"body_html\":\"\\u003cp\\u003e19inch\\u003cbr\\u003ewith anti-theft lock,data cable, earphone cable\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/1_5c401c93-71f5-4f28-8ed5-f729e8a83136.jpg?v=1573127093\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/2_85ec3edb-a21d-49a3-966d-59acfba3d2c4.jpg?v=1573127115\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/3_6919f3ee-b411-46d3-8336-14958a8cc750.jpg?v=1573127135\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/5_1b4ef049-d976-4c12-b29f-e34f460fbb6f.jpg?v=1573127151\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/10_7449a129-19e4-4e8e-94c6-2fd37d0782e0.jpg?v=1573127176\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/12_a76a7c2b-e786-4bc2-b8bb-b5cc12aad0c5.jpg?v=1573127200\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/13_e13b7cc0-f970-49ca-bfa6-047129e99623.jpg?v=1573127221\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\",\"vendor\":\"飚王\",\"product_type\":\"Men\",\"created_at\":\"2019-11-07T19:48:13+08:00\",\"handle\":\"business-backpack-1\",\"updated_at\":\"2019-11-08T09:47:00+08:00\",\"published_at\":\"2019-11-07T10:01:15+08:00\",\"template_suffix\":\"\",\"tags\":\"Men bag\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4349270261857\",\"variants\":[{\"id\":31158183985249,\"product_id\":4349270261857,\"title\":\"Default Title\",\"price\":\"18.99\",\"sku\":\"2901\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Default Title\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T19:48:14+08:00\",\"updated_at\":\"2019-11-08T09:47:00+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":null,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32663248011361,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31158183985249\"}],\"options\":[{\"id\":5648098394209,\"product_id\":4349270261857,\"name\":\"Title\",\"position\":1,\"values\":[\"Default Title\"]}],\"images\":[{\"id\":13458829508705,\"product_id\":4349270261857,\"position\":1,\"created_at\":\"2019-11-07T19:48:13+08:00\",\"updated_at\":\"2019-11-07T19:48:13+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/6_dfe60f51-65f7-4b68-b6a0-cc35deeee15e.jpg?v=1573127293\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458829508705\"},{\"id\":13458829541473,\"product_id\":4349270261857,\"position\":2,\"created_at\":\"2019-11-07T19:48:13+08:00\",\"updated_at\":\"2019-11-07T19:48:13+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/7_4653c1d7-0852-4b2f-9407-2622f5387914.jpg?v=1573127293\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458829541473\"},{\"id\":13458829574241,\"product_id\":4349270261857,\"position\":3,\"created_at\":\"2019-11-07T19:48:13+08:00\",\"updated_at\":\"2019-11-07T19:48:13+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/8_a309cdcf-171e-4f9d-9c48-f051df43e0e0.jpg?v=1573127293\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458829574241\"},{\"id\":13458829607009,\"product_id\":4349270261857,\"position\":4,\"created_at\":\"2019-11-07T19:48:13+08:00\",\"updated_at\":\"2019-11-07T19:48:13+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/9_116c60b8-3d19-40b4-8876-4ae5cb33a9b8.jpg?v=1573127293\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458829607009\"},{\"id\":13458829639777,\"product_id\":4349270261857,\"position\":5,\"created_at\":\"2019-11-07T19:48:13+08:00\",\"updated_at\":\"2019-11-07T19:48:13+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/34.jpg?v=1573127293\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458829639777\"}],\"image\":{\"id\":13458829508705,\"product_id\":4349270261857,\"position\":1,\"created_at\":\"2019-11-07T19:48:13+08:00\",\"updated_at\":\"2019-11-07T19:48:13+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/6_dfe60f51-65f7-4b68-b6a0-cc35deeee15e.jpg?v=1573127293\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458829508705\"}},{\"id\":4348835201121,\"title\":\"Business travel backpack 19inch\",\"body_html\":\"\",\"vendor\":\"飚王\",\"product_type\":\"Men\",\"created_at\":\"2019-11-07T16:32:22+08:00\",\"handle\":\"business-travel-backpack-19inch\",\"updated_at\":\"2019-11-07T16:32:56+08:00\",\"published_at\":\"2019-11-07T10:01:15+08:00\",\"template_suffix\":\"\",\"tags\":\"Men bag\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4348835201121\",\"variants\":[{\"id\":31154822185057,\"product_id\":4348835201121,\"title\":\"Black\",\"price\":\"13.99\",\"sku\":\"2504\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Black\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T16:32:23+08:00\",\"updated_at\":\"2019-11-07T16:32:56+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13455752986721,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32659781976161,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31154822185057\"},{\"id\":31154822217825,\"product_id\":4348835201121,\"title\":\"Brown\",\"price\":\"13.99\",\"sku\":\"2504\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Brown\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T16:32:23+08:00\",\"updated_at\":\"2019-11-07T16:32:56+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13455752953953,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32659782008929,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31154822217825\"},{\"id\":31154822250593,\"product_id\":4348835201121,\"title\":\"Blue\",\"price\":\"13.99\",\"sku\":\"2504\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Blue\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T16:32:23+08:00\",\"updated_at\":\"2019-11-07T16:32:56+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13455753019489,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32659782041697,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31154822250593\"}],\"options\":[{\"id\":5647465971809,\"product_id\":4348835201121,\"name\":\"Color\",\"position\":1,\"values\":[\"Black\",\"Brown\",\"Blue\"]}],\"images\":[{\"id\":13455752953953,\"product_id\":4348835201121,\"position\":1,\"created_at\":\"2019-11-07T16:32:23+08:00\",\"updated_at\":\"2019-11-07T16:32:23+08:00\",\"alt\":null,\"width\":366,\"height\":460,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2504-a.png?v=1573115543\",\"variant_ids\":[31154822217825],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455752953953\"},{\"id\":13455752986721,\"product_id\":4348835201121,\"position\":2,\"created_at\":\"2019-11-07T16:32:23+08:00\",\"updated_at\":\"2019-11-07T16:32:23+08:00\",\"alt\":null,\"width\":372,\"height\":490,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2504-b.png?v=1573115543\",\"variant_ids\":[31154822185057],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455752986721\"},{\"id\":13455753019489,\"product_id\":4348835201121,\"position\":3,\"created_at\":\"2019-11-07T16:32:23+08:00\",\"updated_at\":\"2019-11-07T16:32:23+08:00\",\"alt\":null,\"width\":388,\"height\":480,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2504-c.png?v=1573115543\",\"variant_ids\":[31154822250593],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455753019489\"}],\"image\":{\"id\":13455752953953,\"product_id\":4348835201121,\"position\":1,\"created_at\":\"2019-11-07T16:32:23+08:00\",\"updated_at\":\"2019-11-07T16:32:23+08:00\",\"alt\":null,\"width\":366,\"height\":460,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2504-a.png?v=1573115543\",\"variant_ids\":[31154822217825],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455752953953\"}},{\"id\":4348704096353,\"title\":\"Business waterproof backpack 19inch\",\"body_html\":\"\",\"vendor\":\"飚王\",\"product_type\":\"Men\",\"created_at\":\"2019-11-07T15:44:55+08:00\",\"handle\":\"business-waterproof-backpack-19inch\",\"updated_at\":\"2019-11-07T15:45:51+08:00\",\"published_at\":\"2019-11-07T10:01:15+08:00\",\"template_suffix\":\"\",\"tags\":\"Men bag\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4348704096353\",\"variants\":[{\"id\":31153831936097,\"product_id\":4348704096353,\"title\":\"Black\",\"price\":\"9.99\",\"sku\":\"1326\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Black\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:45:51+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13454840266849,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32658762661985,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31153831936097\"},{\"id\":31153831968865,\"product_id\":4348704096353,\"title\":\"Brown\",\"price\":\"9.99\",\"sku\":\"1326\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Brown\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:45:51+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13454840135777,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32658762694753,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31153831968865\"},{\"id\":31153832001633,\"product_id\":4348704096353,\"title\":\"Purple\",\"price\":\"9.99\",\"sku\":\"1326\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Purple\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:45:51+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13454840234081,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32658762727521,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31153832001633\"},{\"id\":31153832034401,\"product_id\":4348704096353,\"title\":\"Red\",\"price\":\"9.99\",\"sku\":\"1326\",\"position\":4,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Red\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:45:51+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13454840299617,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32658762760289,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31153832034401\"},{\"id\":31153832067169,\"product_id\":4348704096353,\"title\":\"Blue\",\"price\":\"9.99\",\"sku\":\"1326\",\"position\":5,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Blue\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:45:51+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13454840201313,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32658762793057,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31153832067169\"}],\"options\":[{\"id\":5647279849569,\"product_id\":4348704096353,\"name\":\"Color\",\"position\":1,\"values\":[\"Black\",\"Brown\",\"Purple\",\"Red\",\"Blue\"]}],\"images\":[{\"id\":13454840135777,\"product_id\":4348704096353,\"position\":1,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:44:55+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/1_29052936-614a-4235-adf4-187c4ab1ae2e.jpg?v=1573112695\",\"variant_ids\":[31153831968865],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13454840135777\"},{\"id\":13454840201313,\"product_id\":4348704096353,\"position\":2,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:44:55+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2_d443d5de-120c-42d8-a773-7a487b670eac.jpg?v=1573112695\",\"variant_ids\":[31153832067169],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13454840201313\"},{\"id\":13454840234081,\"product_id\":4348704096353,\"position\":3,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:44:55+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/3_76ce9f3f-6a31-4fb3-a6ad-240c2a84c5b7.jpg?v=1573112695\",\"variant_ids\":[31153832001633],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13454840234081\"},{\"id\":13454840266849,\"product_id\":4348704096353,\"position\":4,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:44:55+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/4_419fb16d-c57d-436d-81e6-b73c31f38570.jpg?v=1573112695\",\"variant_ids\":[31153831936097],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13454840266849\"},{\"id\":13454840299617,\"product_id\":4348704096353,\"position\":5,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:44:55+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/5_2b290c08-336b-4b5f-8dd1-fe5499f60c21.jpg?v=1573112695\",\"variant_ids\":[31153832034401],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13454840299617\"}],\"image\":{\"id\":13454840135777,\"product_id\":4348704096353,\"position\":1,\"created_at\":\"2019-11-07T15:44:55+08:00\",\"updated_at\":\"2019-11-07T15:44:55+08:00\",\"alt\":null,\"width\":1000,\"height\":1500,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/1_29052936-614a-4235-adf4-187c4ab1ae2e.jpg?v=1573112695\",\"variant_ids\":[31153831968865],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13454840135777\"}},{\"id\":4286874058849,\"title\":\"Canvas shoe\",\"body_html\":\"\",\"vendor\":\"东泽阿玛尼\",\"product_type\":\"Men\",\"created_at\":\"2019-10-18T17:29:12+08:00\",\"handle\":\"canvas-shoe\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"published_at\":\"2019-10-18T17:25:37+08:00\",\"template_suffix\":null,\"tags\":\"Men Casual shoes\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4286874058849\",\"variants\":[{\"id\":30880829440097,\"product_id\":4286874058849,\"title\":\"38 \\/ black\",\"price\":\"33.99\",\"sku\":\"\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"38\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213681249,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829440097\"},{\"id\":30880829472865,\"product_id\":4286874058849,\"title\":\"38 \\/ white\",\"price\":\"33.99\",\"sku\":\"\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"38\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213714017,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829472865\"},{\"id\":30880829505633,\"product_id\":4286874058849,\"title\":\"39 \\/ black\",\"price\":\"33.99\",\"sku\":\"\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"39\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213746785,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829505633\"},{\"id\":30880829538401,\"product_id\":4286874058849,\"title\":\"39 \\/ white\",\"price\":\"33.99\",\"sku\":\"\",\"position\":4,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"39\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213779553,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829538401\"},{\"id\":30880829571169,\"product_id\":4286874058849,\"title\":\"40 \\/ black\",\"price\":\"33.99\",\"sku\":\"\",\"position\":5,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"40\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213812321,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829571169\"},{\"id\":30880829603937,\"product_id\":4286874058849,\"title\":\"40 \\/ white\",\"price\":\"33.99\",\"sku\":\"\",\"position\":6,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"40\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213845089,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829603937\"},{\"id\":30880829636705,\"product_id\":4286874058849,\"title\":\"41 \\/ black\",\"price\":\"33.99\",\"sku\":\"\",\"position\":7,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"41\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213877857,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829636705\"},{\"id\":30880829669473,\"product_id\":4286874058849,\"title\":\"41 \\/ white\",\"price\":\"33.99\",\"sku\":\"\",\"position\":8,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"41\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213910625,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829669473\"},{\"id\":30880829702241,\"product_id\":4286874058849,\"title\":\"42 \\/ black\",\"price\":\"33.99\",\"sku\":\"\",\"position\":9,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"42\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213943393,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829702241\"},{\"id\":30880829735009,\"product_id\":4286874058849,\"title\":\"42 \\/ white\",\"price\":\"33.99\",\"sku\":\"\",\"position\":10,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"42\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294213976161,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829735009\"},{\"id\":30880829767777,\"product_id\":4286874058849,\"title\":\"43 \\/ black\",\"price\":\"33.99\",\"sku\":\"\",\"position\":11,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"43\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294214008929,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829767777\"},{\"id\":30880829800545,\"product_id\":4286874058849,\"title\":\"43 \\/ white\",\"price\":\"33.99\",\"sku\":\"\",\"position\":12,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"43\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T17:29:13+08:00\",\"updated_at\":\"2019-10-18T17:29:45+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":400,\"image_id\":null,\"weight\":0.4,\"weight_unit\":\"kg\",\"inventory_item_id\":32294214041697,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30880829800545\"}],\"options\":[{\"id\":5574363676769,\"product_id\":4286874058849,\"name\":\"Size\",\"position\":1,\"values\":[\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]},{\"id\":5574363709537,\"product_id\":4286874058849,\"name\":\"Color\",\"position\":2,\"values\":[\"black\",\"white\"]}],\"images\":[{\"id\":13215206506593,\"product_id\":4286874058849,\"position\":1,\"created_at\":\"2019-10-18T17:29:20+08:00\",\"updated_at\":\"2019-10-18T17:29:20+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/0ad9310e94cb73c4fa398de7533626b.jpg?v=1571390960\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215206506593\"},{\"id\":13215207784545,\"product_id\":4286874058849,\"position\":2,\"created_at\":\"2019-10-18T17:29:25+08:00\",\"updated_at\":\"2019-10-18T17:29:25+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/5bb6f757f2d3c9a5b7d9ee61caf39b5.jpg?v=1571390965\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215207784545\"},{\"id\":13215208505441,\"product_id\":4286874058849,\"position\":3,\"created_at\":\"2019-10-18T17:29:29+08:00\",\"updated_at\":\"2019-10-18T17:29:29+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/478d5dbe96a1ad4be12526fd47c05ef.jpg?v=1571390969\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215208505441\"}],\"image\":{\"id\":13215206506593,\"product_id\":4286874058849,\"position\":1,\"created_at\":\"2019-10-18T17:29:20+08:00\",\"updated_at\":\"2019-10-18T17:29:20+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/0ad9310e94cb73c4fa398de7533626b.jpg?v=1571390960\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215206506593\"}},{\"id\":4286953193569,\"title\":\"Canvas shoe\",\"body_html\":\"\",\"vendor\":\"东泽阿玛尼\",\"product_type\":\"Men\",\"created_at\":\"2019-10-18T18:38:59+08:00\",\"handle\":\"canvas-shoe-1\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"published_at\":\"2019-10-18T18:36:07+08:00\",\"template_suffix\":\"\",\"tags\":\"Men Casual shoes\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4286953193569\",\"variants\":[{\"id\":30881283735649,\"product_id\":4286953193569,\"title\":\"38 \\/ black\",\"price\":\"41.99\",\"sku\":\"\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"38\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215997886561,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741016673,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283735649\"},{\"id\":30881283768417,\"product_id\":4286953193569,\"title\":\"38 \\/ white\",\"price\":\"41.99\",\"sku\":\"\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"38\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215998345313,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741049441,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283768417\"},{\"id\":30881283801185,\"product_id\":4286953193569,\"title\":\"39 \\/ black\",\"price\":\"41.99\",\"sku\":\"\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"39\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215997886561,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741082209,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283801185\"},{\"id\":30881283833953,\"product_id\":4286953193569,\"title\":\"39 \\/ white\",\"price\":\"41.99\",\"sku\":\"\",\"position\":4,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"39\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215998345313,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741114977,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283833953\"},{\"id\":30881283866721,\"product_id\":4286953193569,\"title\":\"40 \\/ black\",\"price\":\"41.99\",\"sku\":\"\",\"position\":5,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"40\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215997886561,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741147745,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283866721\"},{\"id\":30881283899489,\"product_id\":4286953193569,\"title\":\"40 \\/ white\",\"price\":\"41.99\",\"sku\":\"\",\"position\":6,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"40\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215998345313,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741180513,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283899489\"},{\"id\":30881283932257,\"product_id\":4286953193569,\"title\":\"41 \\/ black\",\"price\":\"41.99\",\"sku\":\"\",\"position\":7,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"41\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215997886561,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741213281,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283932257\"},{\"id\":30881283965025,\"product_id\":4286953193569,\"title\":\"41 \\/ white\",\"price\":\"41.99\",\"sku\":\"\",\"position\":8,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"41\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215998345313,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741246049,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283965025\"},{\"id\":30881283997793,\"product_id\":4286953193569,\"title\":\"42 \\/ black\",\"price\":\"41.99\",\"sku\":\"\",\"position\":9,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"42\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215997886561,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741278817,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881283997793\"},{\"id\":30881284030561,\"product_id\":4286953193569,\"title\":\"42 \\/ white\",\"price\":\"41.99\",\"sku\":\"\",\"position\":10,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"42\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215998345313,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741311585,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881284030561\"},{\"id\":30881284063329,\"product_id\":4286953193569,\"title\":\"43 \\/ black\",\"price\":\"41.99\",\"sku\":\"\",\"position\":11,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"43\",\"option2\":\"black\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215997886561,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741344353,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881284063329\"},{\"id\":30881284096097,\"product_id\":4286953193569,\"title\":\"43 \\/ white\",\"price\":\"41.99\",\"sku\":\"\",\"position\":12,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"43\",\"option2\":\"white\",\"option3\":null,\"created_at\":\"2019-10-18T18:39:01+08:00\",\"updated_at\":\"2019-10-22T15:53:39+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13215998345313,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32294741377121,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/30881284096097\"}],\"options\":[{\"id\":5574469025889,\"product_id\":4286953193569,\"name\":\"Size\",\"position\":1,\"values\":[\"38\",\"39\",\"40\",\"41\",\"42\",\"43\"]},{\"id\":5574469058657,\"product_id\":4286953193569,\"name\":\"Color\",\"position\":2,\"values\":[\"black\",\"white\"]}],\"images\":[{\"id\":13215984484449,\"product_id\":4286953193569,\"position\":1,\"created_at\":\"2019-10-18T18:39:09+08:00\",\"updated_at\":\"2019-10-18T18:39:09+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2dcb422829101504cdb999dc1ed8c8a.jpg?v=1571395149\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215984484449\"},{\"id\":13215997886561,\"product_id\":4286953193569,\"position\":2,\"created_at\":\"2019-10-18T18:39:19+08:00\",\"updated_at\":\"2019-10-18T18:39:19+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/557d316ed87650e182e49875602fc5f.jpg?v=1571395159\",\"variant_ids\":[30881283735649,30881283801185,30881283866721,30881283932257,30881283997793,30881284063329],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215997886561\"},{\"id\":13215998345313,\"product_id\":4286953193569,\"position\":3,\"created_at\":\"2019-10-18T18:39:25+08:00\",\"updated_at\":\"2019-10-18T18:39:25+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/7503883ee319a7be99546c5aa65c311.jpg?v=1571395165\",\"variant_ids\":[30881283768417,30881283833953,30881283899489,30881283965025,30881284030561,30881284096097],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215998345313\"},{\"id\":13215998771297,\"product_id\":4286953193569,\"position\":4,\"created_at\":\"2019-10-18T18:39:30+08:00\",\"updated_at\":\"2019-10-18T18:39:30+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/e248d04b310e4b5a4ce181ab30455ad.jpg?v=1571395170\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215998771297\"}],\"image\":{\"id\":13215984484449,\"product_id\":4286953193569,\"position\":1,\"created_at\":\"2019-10-18T18:39:09+08:00\",\"updated_at\":\"2019-10-18T18:39:09+08:00\",\"alt\":null,\"width\":1440,\"height\":1080,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2dcb422829101504cdb999dc1ed8c8a.jpg?v=1571395149\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13215984484449\"}},{\"id\":4349192241249,\"title\":\"Casual backpack\",\"body_html\":\"\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/1_8fba92b6-699a-45cb-85b3-dd364cb5331d.jpg?v=1573124380\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/2_03f39935-a1ac-4c2c-809a-1ed0e1d3c144.jpg?v=1573124399\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/3_f53492f6-4942-4c6a-8a59-5111f3c6e498.jpg?v=1573124419\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/6_1cd0f64b-c090-46cf-b578-976b38958fea.jpg?v=1573124440\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/9_2157211c-8806-43a3-a4f3-b5bc9bcad594.jpg?v=1573124467\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\\n\\u003cp\\u003e\\u003cimg src=\\\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/files\\/8_6875b9b4-38b5-40e8-b79b-666eab264100.jpg?v=1573124487\\\" alt=\\\"\\\"\\u003e\\u003c\\/p\\u003e\",\"vendor\":\"飚王\",\"product_type\":\"Men\",\"created_at\":\"2019-11-07T19:05:28+08:00\",\"handle\":\"casual-backpack-1\",\"updated_at\":\"2019-11-07T19:06:05+08:00\",\"published_at\":\"2019-11-07T10:01:15+08:00\",\"template_suffix\":\"\",\"tags\":\"\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4349192241249\",\"variants\":[{\"id\":31157653766241,\"product_id\":4349192241249,\"title\":\"Black\",\"price\":\"11.99\",\"sku\":\"3005\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Black\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T19:05:29+08:00\",\"updated_at\":\"2019-11-07T19:06:05+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13458253381729,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32662697214049,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31157653766241\"},{\"id\":31157653799009,\"product_id\":4349192241249,\"title\":\"Brown\",\"price\":\"11.99\",\"sku\":\"3005\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Brown\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T19:05:29+08:00\",\"updated_at\":\"2019-11-07T19:06:05+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13458253611105,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32662697246817,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31157653799009\"},{\"id\":31157653831777,\"product_id\":4349192241249,\"title\":\"Orange\",\"price\":\"11.99\",\"sku\":\"3005\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Orange\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T19:05:29+08:00\",\"updated_at\":\"2019-11-07T19:06:05+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13458253709409,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32662697312353,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31157653831777\"}],\"options\":[{\"id\":5647979380833,\"product_id\":4349192241249,\"name\":\"Color\",\"position\":1,\"values\":[\"Black\",\"Brown\",\"Orange\"]}],\"images\":[{\"id\":13458253381729,\"product_id\":4349192241249,\"position\":1,\"created_at\":\"2019-11-07T19:05:28+08:00\",\"updated_at\":\"2019-11-07T19:05:28+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/16_43458f22-10f3-4eb6-8bfd-c0a693499ca1.jpg?v=1573124728\",\"variant_ids\":[31157653766241],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253381729\"},{\"id\":13458253480033,\"product_id\":4349192241249,\"position\":2,\"created_at\":\"2019-11-07T19:05:28+08:00\",\"updated_at\":\"2019-11-07T19:05:28+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/12_39e415a4-f5d4-40e9-bb6f-4cc550b23f80.jpg?v=1573124728\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253480033\"},{\"id\":13458253545569,\"product_id\":4349192241249,\"position\":3,\"created_at\":\"2019-11-07T19:05:28+08:00\",\"updated_at\":\"2019-11-07T19:05:28+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/14_bf427421-98cd-4b63-a951-060dd2ec8479.jpg?v=1573124728\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253545569\"},{\"id\":13458253578337,\"product_id\":4349192241249,\"position\":4,\"created_at\":\"2019-11-07T19:05:28+08:00\",\"updated_at\":\"2019-11-07T19:05:28+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/17_da1464fa-7d2f-4e40-a555-9b3f6f9df88f.jpg?v=1573124728\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253578337\"},{\"id\":13458253611105,\"product_id\":4349192241249,\"position\":5,\"created_at\":\"2019-11-07T19:05:29+08:00\",\"updated_at\":\"2019-11-07T19:05:29+08:00\",\"alt\":null,\"width\":1000,\"height\":666,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/18_44ff9997-e6a7-4fa4-b915-fb8211ad08cd.jpg?v=1573124729\",\"variant_ids\":[31157653799009],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253611105\"},{\"id\":13458253643873,\"product_id\":4349192241249,\"position\":6,\"created_at\":\"2019-11-07T19:05:29+08:00\",\"updated_at\":\"2019-11-07T19:05:29+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/19_b4e3b22c-f19e-4901-aacd-22b68cb7ae4e.jpg?v=1573124729\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253643873\"},{\"id\":13458253709409,\"product_id\":4349192241249,\"position\":7,\"created_at\":\"2019-11-07T19:05:29+08:00\",\"updated_at\":\"2019-11-07T19:05:29+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/20_e8610108-64b7-4b74-a278-0d895259be34.jpg?v=1573124729\",\"variant_ids\":[31157653831777],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253709409\"},{\"id\":13458253742177,\"product_id\":4349192241249,\"position\":8,\"created_at\":\"2019-11-07T19:05:29+08:00\",\"updated_at\":\"2019-11-07T19:05:29+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/11_b2dfc2c0-c669-46d8-9b64-a0b2170b1713.jpg?v=1573124729\",\"variant_ids\":[],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253742177\"}],\"image\":{\"id\":13458253381729,\"product_id\":4349192241249,\"position\":1,\"created_at\":\"2019-11-07T19:05:28+08:00\",\"updated_at\":\"2019-11-07T19:05:28+08:00\",\"alt\":null,\"width\":1000,\"height\":667,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/16_43458f22-10f3-4eb6-8bfd-c0a693499ca1.jpg?v=1573124728\",\"variant_ids\":[31157653766241],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13458253381729\"}},{\"id\":4348777857121,\"title\":\"Casual backpack 19inch\",\"body_html\":\"\",\"vendor\":\"飚王\",\"product_type\":\"Men\",\"created_at\":\"2019-11-07T16:07:56+08:00\",\"handle\":\"casual-backpack\",\"updated_at\":\"2019-11-07T16:08:38+08:00\",\"published_at\":\"2019-11-07T10:01:15+08:00\",\"template_suffix\":\"\",\"tags\":\"Men bag\",\"published_scope\":\"web\",\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/Product\\/4348777857121\",\"variants\":[{\"id\":31154294653025,\"product_id\":4348777857121,\"title\":\"Black\",\"price\":\"13.99\",\"sku\":\"2501\",\"position\":1,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Black\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T16:07:56+08:00\",\"updated_at\":\"2019-11-07T16:08:20+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13455266087009,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32659236880481,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31154294653025\"},{\"id\":31154294685793,\"product_id\":4348777857121,\"title\":\"Brown\",\"price\":\"13.99\",\"sku\":\"2501\",\"position\":2,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Brown\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T16:07:56+08:00\",\"updated_at\":\"2019-11-07T16:08:20+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13455266054241,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32659236913249,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31154294685793\"},{\"id\":31154294718561,\"product_id\":4348777857121,\"title\":\"Blue\",\"price\":\"13.99\",\"sku\":\"2501\",\"position\":3,\"inventory_policy\":\"deny\",\"compare_at_price\":null,\"fulfillment_service\":\"manual\",\"inventory_management\":\"shopify\",\"option1\":\"Blue\",\"option2\":null,\"option3\":null,\"created_at\":\"2019-11-07T16:07:56+08:00\",\"updated_at\":\"2019-11-07T16:08:20+08:00\",\"taxable\":true,\"barcode\":\"\",\"grams\":500,\"image_id\":13455266119777,\"weight\":0.5,\"weight_unit\":\"kg\",\"inventory_item_id\":32659236946017,\"inventory_quantity\":50,\"old_inventory_quantity\":50,\"requires_shipping\":true,\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductVariant\\/31154294718561\"}],\"options\":[{\"id\":5647379365985,\"product_id\":4348777857121,\"name\":\"Color\",\"position\":1,\"values\":[\"Black\",\"Brown\",\"Blue\"]}],\"images\":[{\"id\":13455266054241,\"product_id\":4348777857121,\"position\":1,\"created_at\":\"2019-11-07T16:07:56+08:00\",\"updated_at\":\"2019-11-07T16:07:56+08:00\",\"alt\":null,\"width\":3542,\"height\":5313,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/BW-2501.jpg?v=1573114076\",\"variant_ids\":[31154294685793],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455266054241\"},{\"id\":13455266087009,\"product_id\":4348777857121,\"position\":2,\"created_at\":\"2019-11-07T16:07:56+08:00\",\"updated_at\":\"2019-11-07T16:07:56+08:00\",\"alt\":null,\"width\":401,\"height\":509,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2501-a.png?v=1573114076\",\"variant_ids\":[31154294653025],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455266087009\"},{\"id\":13455266119777,\"product_id\":4348777857121,\"position\":3,\"created_at\":\"2019-11-07T16:07:56+08:00\",\"updated_at\":\"2019-11-07T16:07:56+08:00\",\"alt\":null,\"width\":392,\"height\":487,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/2501-b.png?v=1573114076\",\"variant_ids\":[31154294718561],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455266119777\"}],\"image\":{\"id\":13455266054241,\"product_id\":4348777857121,\"position\":1,\"created_at\":\"2019-11-07T16:07:56+08:00\",\"updated_at\":\"2019-11-07T16:07:56+08:00\",\"alt\":null,\"width\":3542,\"height\":5313,\"src\":\"https:\\/\\/cdn.shopify.com\\/s\\/files\\/1\\/0079\\/8330\\/0705\\/products\\/BW-2501.jpg?v=1573114076\",\"variant_ids\":[31154294685793],\"admin_graphql_api_id\":\"gid:\\/\\/shopify\\/ProductImage\\/13455266054241\"}}]}\n";
        List list = new ArrayList();
        com.alibaba.fastjson.JSONObject object = JSON.parseObject(str);
        com.alibaba.fastjson.JSONArray products = object.getJSONArray("products");
        for (int i = 0; i < products.size(); i++) {
            com.alibaba.fastjson.JSONObject jsonObject = products.getJSONObject(i);
            list.add(jsonObject);
        }
        List<String> strings = ListUtil.pageBySubList(list, 1, 10);
        System.out.println(strings);
    }

    public static List<String> pageBySubList(List list, int pagesize, int currentPage) {
        int totalcount = list.size();
        int pagecount = 0;
        List<String> subList;
        int m = totalcount % pagesize;
        if (m > 0) {
            pagecount = totalcount / pagesize + 1;
        } else {
            pagecount = totalcount / pagesize;
        }
        if (m == 0) {
            subList = list.subList((currentPage - 1) * pagesize, pagesize * (currentPage));
        } else {
            if (currentPage == pagecount) {
                subList = list.subList((currentPage - 1) * pagesize, totalcount);
            } else {
                subList = list.subList((currentPage - 1) * pagesize, pagesize * (currentPage));
            }
        }
        return subList;
    }

}
