$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfversion/list',
        colModel: [
			{label: 'versionId', name: 'versionId', index: 'version_id', key: true, hidden: true},
			{label: '版本code', name: 'versionCode', index: 'version_code', width: 80},
			{label: '版本更新链接', name: 'versionLike', index: 'version_like', width: 80},
			{label: '版本更新内容', name: 'versionDetail', index: 'version_detail', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfVersion: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfVersion = {};
			UE.getEditor('Detail').setContent(""); // 富文本赋值
		},
		update: function (event) {
			let versionId = getSelectedRow("#jqGrid");
			if (versionId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(versionId);
		},
		saveOrUpdate: function (event) {
			vm.tbCfVersion.versionDetail = encodeURI(UE.getEditor('Detail').getContent()); // 富文本取值
			vm.tbCfVersion.versionDetail = vm.tbCfVersion.versionDetail.replace(/&nbsp;/g, " ");
			let url = vm.tbCfVersion.versionId == null ? "../tbcfversion/save" : "../tbcfversion/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfVersion),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let versionIds = getSelectedRows("#jqGrid");
			if (versionIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfversion/delete",
                    params: JSON.stringify(versionIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(versionId){
            Ajax.request({
                url: "../tbcfversion/info/"+versionId,
                async: false,
                successCallback: function (r) {
                    vm.tbCfVersion = r.tbCfVersion;
					UE.getEditor('Detail').setContent(vm.tbCfVersion.versionDetail); // 富文本赋值
                    console.log(vm.tbCfVersion);

                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});