$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfuserinfo/list',
        colModel: [
			{label: 'userId', name: 'userId', index: 'user_id', key: true, hidden: true},
			{label: '用户编号', name: 'userNo', index: 'user_no', width: 160},
			{label: '用户类型', name: 'userType', index: 'user_type', width: 80,formatter:userTypeFormat},
			{label: '账号', name: 'account', index: 'account', width: 120},
			{label: '用户头像地址', name: 'avatar', index: 'avatar', width: 100,formatter:imageFormat},
			{label: '用户名', name: 'nick', index: 'nick', width: 80},
			{label: '下单次数', name: 'count', index: 'count', width: 80},
			{label: '总金额', name: 'total', index: 'total', width: 80,formatter:moneyFormat},
			{label: '使用优惠券次数', name: 'num', index: 'num', width: 80},
			{label: '电话号码', name: 'phone', index: 'phone', width: 100},
			{label: '是否绑定手机', name: 'phoneFlag', index: 'phone_flag', width: 80,formatter:yesOrNoFormat},
			{label: '密码', name: 'password', index: 'password', width: 80, hidden: true},
			{label: '上一次登录时间', name: 'lastLoginTime', index: 'last_login_time', width: 120},
			{label: '上一次登录IP', name: 'lastLoginIp', index: 'last_login_ip', width: 80},
			{label: '登录次数', name: 'loginCount', index: 'login_count', width: 60},
			{label: '邮箱', name: 'email', index: 'email', width: 120},
			{label: 'facebook账号', name: 'facebook', index: 'facebook', width: 120},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 120},
			{label: '性别', name: 'sex', index: 'sex', width: 80,formatter:sexFormat},
			{label: '默认地址id', name: 'defaultAddressId', index: 'default_address_id', width: 200},
			{label: '邀请用户', name: 'invitedUserId', index: 'invited_user_id', width: 120},
			{label: '邀请人数', name: 'invitedCount', index: 'invited_count', width: 80},
			{label: '是否有效', name: 'enableFlag', index: 'enable_flag', width: 60,formatter:yesOrNoFormat},
			{label: '邮箱是否已经验证', name: 'emailFlag', index: 'email_flag', width: 80,formatter:yesOrNoFormat}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfUserInfo: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfUserInfo = {};
		},
		update: function (event) {
            let userId = getSelectedRow("#jqGrid");
			if (userId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(userId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfUserInfo.userId == null ? "../tbcfuserinfo/save" : "../tbcfuserinfo/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfUserInfo),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let userIds = getSelectedRows("#jqGrid");
			if (userIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfuserinfo/delete",
                    params: JSON.stringify(userIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(userId){
            Ajax.request({
                url: "../tbcfuserinfo/info/"+userId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfUserInfo = r.tbCfUserInfo;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});