$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfdailyfinance/list',
        colModel: [
			{label: 'statisticsId', name: 'statisticsId', index: 'statistics_id', key: true, hidden: true},
			{label: '下单数', name: 'orderCount', index: 'order_count', width: 80},
			{label: '下单用户数', name: 'userCount', index: 'user_count', width: 80},
			{label: '下单商品数', name: 'itemCount', index: 'item_count', width: 80},
			{label: '平均价格', name: 'itemAveragePrice', index: 'item_average_price', width: 80},
			{label: '下单总额', name: 'totalSales', index: 'total_sales', width: 80},
			{label: '统计时间', name: 'statisticsTime', index: 'statistics_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfDailyFinance: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfDailyFinance = {};
		},
		update: function (event) {
            let statisticsId = getSelectedRow("#jqGrid");
			if (statisticsId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(statisticsId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfDailyFinance.statisticsId == null ? "../tbcfdailyfinance/save" : "../tbcfdailyfinance/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfDailyFinance),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let statisticsIds = getSelectedRows("#jqGrid");
			if (statisticsIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfdailyfinance/delete",
                    params: JSON.stringify(statisticsIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(statisticsId){
            Ajax.request({
                url: "../tbcfdailyfinance/info/"+statisticsId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfDailyFinance = r.tbCfDailyFinance;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});