$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfaddress/list',
        colModel: [
			{label: 'addressId', name: 'addressId', index: 'address_id', key: true, hidden: true},
			{label: '用户id', name: 'userId', index: 'user_id', width: 80},
			{label: '收货人', name: 'deliveryName', index: 'delivery_name', width: 80},
			{label: '联系电话', name: 'phone', index: 'phone', width: 80},
			{label: '是否为默认地址', name: 'defaultFlag', index: 'default_flag', width: 80},
			{label: '地址详情', name: 'addressDetail', index: 'address_detail', width: 80},
			{label: '所在国家code', name: 'addressCountryCode', index: 'address_country_code', width: 80},
			{label: '所在国家', name: 'addressCountryName', index: 'address_country_name', width: 80},
			{label: '所在州code', name: 'addressStateCode', index: 'address_state_code', width: 80},
			{label: '所在州', name: 'addressStateName', index: 'address_state_name', width: 80},
			{label: '所在区code', name: 'addressAreaCode', index: 'address_area_code', width: 80},
			{label: '所在区', name: 'addressAreaName', index: 'address_area_name', width: 80},
			{label: '标签code', name: 'labelCode', index: 'label_code', width: 80},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80},
			{label: '修改时间', name: 'updateTime', index: 'update_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfAddress: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfAddress = {};
		},
		update: function (event) {
            let addressId = getSelectedRow("#jqGrid");
			if (addressId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(addressId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfAddress.addressId == null ? "../tbcfaddress/save" : "../tbcfaddress/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfAddress),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let addressIds = getSelectedRows("#jqGrid");
			if (addressIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfaddress/delete",
                    params: JSON.stringify(addressIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(addressId){
            Ajax.request({
                url: "../tbcfaddress/info/"+addressId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfAddress = r.tbCfAddress;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});