package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfStationItemDao;
import com.diaoyun.zion.chinafrica.entity.TbCfPlatformEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfStationItemEntity;
import com.diaoyun.zion.chinafrica.service.TbCfStationItemService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.util.IdUtil;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 站点商品Service实现类
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Service("tbCfStationItemService")
public class TbCfStationItemServiceImpl implements TbCfStationItemService {
    @Autowired
    private TbCfStationItemDao tbCfStationItemDao;

    @Override
    public TbCfStationItemEntity queryObject(String itemId) {
        return tbCfStationItemDao.queryObject(itemId);
    }

    @Override
    public List<TbCfStationItemEntity> getGoodsTypeList(String categoryId) {
        return tbCfStationItemDao.getGoodsTypeList(categoryId);
    }

    @Override
    public List<TbCfStationItemEntity> queryList(Map<String, Object> map) {
        return tbCfStationItemDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfStationItemDao.queryTotal(map);
    }

    @Override
    public int save(TbCfStationItemEntity tbCfStationItem) {
        tbCfStationItem.setItemId(IdUtil.createIdbyUUID());
        return tbCfStationItemDao.save(tbCfStationItem);
    }

    @Override
    public int update(TbCfStationItemEntity tbCfStationItem) {
        return tbCfStationItemDao.update(tbCfStationItem);
    }

    @Override
    public int delete(String itemId) {
        return tbCfStationItemDao.delete(itemId);
    }

    @Override
    public int deleteBatch(String[] itemIds) {
        return tbCfStationItemDao.deleteBatch(itemIds);
    }

    @Override
    public Result getItemStationList(Integer pageNum, Integer pageSize,String categoryId) {
        Result<PageInfo> result = new Result<>();
        startPage(pageNum,pageSize);
        List<TbCfStationItemEntity> tbCfStationItemList=tbCfStationItemDao.getItemStationList(categoryId);
        PageInfo<TbCfStationItemEntity> pageInfo = new PageInfo<>(tbCfStationItemList);
        result.setData(pageInfo);
        return result;
    }
}
