package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfPlatformDao;
import com.diaoyun.zion.chinafrica.entity.TbCfPlatformEntity;
import com.diaoyun.zion.chinafrica.service.TbCfPlatformService;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.util.IdUtil;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

import static com.github.pagehelper.page.PageMethod.startPage;

/**
 * 平台管理Service实现类
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Service("tbCfPlatformService")
public class TbCfPlatformServiceImpl implements TbCfPlatformService {
    @Autowired
    private TbCfPlatformDao tbCfPlatformDao;

    @Override
    public TbCfPlatformEntity queryObject(String platformId) {
        return tbCfPlatformDao.queryObject(platformId);
    }

    @Override
    public List<TbCfPlatformEntity> queryList(Map<String, Object> map) {
        return tbCfPlatformDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfPlatformDao.queryTotal(map);
    }

    @Override
    public int save(TbCfPlatformEntity tbCfPlatform) {
        tbCfPlatform.setPlatformId(IdUtil.createIdbyUUID());
        return tbCfPlatformDao.save(tbCfPlatform);
    }

    @Override
    public int update(TbCfPlatformEntity tbCfPlatform) {
        return tbCfPlatformDao.update(tbCfPlatform);
    }

    @Override
    public int delete(String platformId) {
        return tbCfPlatformDao.delete(platformId);
    }

    @Override
    public int deleteBatch(String[] platformIds) {
        return tbCfPlatformDao.deleteBatch(platformIds);
    }

    @Override
    public Result getPlatformList(Integer pageNum, Integer pageSize) {
        Result<PageInfo> result = new Result<>();
        startPage(pageNum,pageSize);
        List<TbCfPlatformEntity> tbCfPlatformList=tbCfPlatformDao.getPlatformList();
        PageInfo<TbCfPlatformEntity> pageInfo = new PageInfo<>(tbCfPlatformList);
        result.setData(pageInfo);
        return result;
    }
}
