package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfCouponCategoryDao;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponCategoryEntity;
import com.diaoyun.zion.chinafrica.service.TbCfCouponCategoryService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 优惠券类型Service实现类
 *
 * @author lipengjun
 * @date 2019-10-22 10:23:49
 */
@Service("tbCfCouponCategoryService")
public class TbCfCouponCategoryServiceImpl implements TbCfCouponCategoryService {
    @Autowired
    private TbCfCouponCategoryDao tbCfCouponCategoryDao;

    @Override
    public TbCfCouponCategoryEntity queryObject(String couponCategoryId) {
        return tbCfCouponCategoryDao.queryObject(couponCategoryId);
    }

    @Override
    public List<TbCfCouponCategoryEntity> queryList(Map<String, Object> map) {
        return tbCfCouponCategoryDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfCouponCategoryDao.queryTotal(map);
    }

    @Override
    public int save(TbCfCouponCategoryEntity tbCfCouponCategory) {
        tbCfCouponCategory.setCouponCategoryId(IdUtil.createIdbyUUID());
        return tbCfCouponCategoryDao.save(tbCfCouponCategory);
    }

    @Override
    public int update(TbCfCouponCategoryEntity tbCfCouponCategory) {
        return tbCfCouponCategoryDao.update(tbCfCouponCategory);
    }

    @Override
    public int delete(String couponCategoryId) {
        return tbCfCouponCategoryDao.delete(couponCategoryId);
    }

    @Override
    public int deleteBatch(String[] couponCategoryIds) {
        return tbCfCouponCategoryDao.deleteBatch(couponCategoryIds);
    }

    @Override
    public List<TbCfCouponCategoryEntity> queryByCouponCategoryId(String categoryId) {
        return tbCfCouponCategoryDao.queryByCouponCategoryId(categoryId);
    }
}
