package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfFinanceEntity;

import java.util.List;
import java.util.Map;

/**
 * 财务明细Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
public interface TbCfFinanceService {

    /**
     * 根据主键查询实体
     *
     * @param finaceId 主键
     * @return 实体
     */
    TbCfFinanceEntity queryObject(String finaceId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfFinanceEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfFinance 实体
     * @return 保存条数
     */
    int save(TbCfFinanceEntity tbCfFinance);

    /**
     * 根据主键更新实体
     *
     * @param tbCfFinance 实体
     * @return 更新条数
     */
    int update(TbCfFinanceEntity tbCfFinance);

    /**
     * 根据主键删除
     *
     * @param finaceId
     * @return 删除条数
     */
    int delete(String finaceId);

    /**
     * 根据主键批量删除
     *
     * @param finaceIds
     * @return 删除条数
     */
    int deleteBatch(String[] finaceIds);
}
