package com.diaoyun.zion.chinafrica.dao;

import com.diaoyun.zion.chinafrica.entity.TbCfCouponIssueEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.master.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 优惠券发放Dao
 *
 * @author lipengjun
 * @date 2019-10-21 12:11:53
 */
public interface TbCfCouponIssueDao extends BaseDao<TbCfCouponIssueEntity> {

    /**
     * 判断用户状态(已下单，未下单，新用户，添加购物车的用户)
     * @param status
     * @return
     */
    List<TbCfUserInfoEntity> queryByUserStatus(@Param("status") Integer status);

    /**
     * 根据状态获取符合条件的用户列表
     * @param couponIssueId
     * @return
     */
    int queryByStatus(String couponIssueId);

}
