package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.FlutterWaveService;
import com.diaoyun.zion.chinafrica.vo.FlutterWaveCard;
import com.diaoyun.zion.master.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @Auther: wudepeng
 * @Date: 2019/11/08
 * @Description: FlutterWave支付
 */
@RestController
@RequestMapping("/flutterwave")
public class FlutterWaveController {
    @Autowired
    private FlutterWaveService flutterWaveService;

    /**
     * 发起支付
     *
     * @param orderId         订单ID
     * @param flutterWaveCard 账号信息
     * @return
     */
    @PostMapping("/pay")
    public Result payForOrderByCard(@RequestParam("orderId") String orderId, @RequestBody FlutterWaveCard flutterWaveCard) {
        return flutterWaveService.payForOrder(orderId, flutterWaveCard);
    }

    /**
     * 退款
     * @param flutterWaveCard
     * @return
     */
    @PostMapping("/refund")
    public Result refund(@RequestBody FlutterWaveCard flutterWaveCard) {
        return flutterWaveService.refund(flutterWaveCard);
    }

}
