package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * MO&Co. 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("mocoSpider")
public class MocoSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(ZaraSpider.class);

    /**
     * MO&Co. 数据爬虫
     *
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 截取链接中的商品id
        String[] spilt = targetUrl.split("/p/");
        String pId = spilt[1];
        targetUrl = "https://www.moco.com/moco/zh/ajax/variant/" + pId;
        // 通过接口获取主要商品的内容
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.MOCO.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        // 格式化数据
        ProductResponse productResponse = formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        // 翻译数据
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     *
     * @param dataMap 主要的 Json 内容
     * @param pId     截取的商品 id
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(false);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 取 productData 对象节点
        JSONObject productDataObj = dataMap.getJSONObject("productData");

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////////////////////
        itemInfo.setShopName("MO&Co.");
        itemInfo.setShopUrl("https://en.mo-co.com/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(productDataObj.getString("name"));
        //////////////////////////////////// 获取商品基本信息End(图片下取) ////////////////////////////////////////////

        JSONArray options_1_Arr = productDataObj.getJSONArray("baseOptions").getJSONObject(1).getJSONArray("options");
        JSONArray options_0_Arr = productDataObj.getJSONArray("baseOptions").getJSONObject(0).getJSONArray("options");
        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////

        for (int i = 0; i < options_1_Arr.size(); i++) {
            JSONObject options_1_Obj = options_1_Arr.getJSONObject(i);

            // 获取图片的路径
            String[] spiltImg = options_1_Obj.getJSONArray("variantOptionQualifiers")
                    .getJSONObject(0).getJSONObject("image").getString("url").split("_other_");

            String colorNo = options_1_Obj.getString("epoColorCode");
            String color = options_1_Obj.getString("epoColorName");
            String imageUrl = "https://mallimg.moco.com/" + pId + "_list_" + spiltImg[1];

            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imageUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////
            ///////////////////////// 获取商品尺码属性 ///////////////////////////////////////////////////////////
            for (int j = 0; j < options_0_Arr.size(); j++) {
                JSONObject options_0_Obj = options_0_Arr.getJSONObject(j);

                String sizeNo = options_0_Obj.getString("epoSizeCode");
                String size = options_0_Obj.getString("epoSizeName") + options_0_Obj.getString("sizeDescription");

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////

                // 设置 skuStr
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                // 设置：商品包含库存信息
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////

                String fullPrice = productDataObj.getJSONObject("price").getString("value");
                fullPrice = exchangeRate(fullPrice);

                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("MO&Co.");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
