package com.diaoyun.zion.chinafrica.api;

import com.diaoyun.zion.chinafrica.service.TbCfOrderService;
import com.diaoyun.zion.chinafrica.service.TbCfUserInfoService;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 提供给第三方api
 * @author G
 *
 */
@Api(tags = "提供给第三方api")
@RestController
@RequestMapping("/chinafrica/api")
public class ThirdPartyController {

	private static Logger logger= LoggerFactory.getLogger(ThirdPartyController.class);

	@Autowired
    private TbCfOrderService tbCfOrderService;
    @Autowired
    private  TbCfUserInfoService tbCfUserInfoService;

    /**
     *获取某段时间的付款订单数据
     */
    @ApiOperation(value = "获取某段时间的付款订单数据")
    @GetMapping(value ="/order")
    public Result getOrderList(@ApiParam(value ="开始时间") @RequestParam("beginTime")long beginTime,
                               @ApiParam(value ="结束时间") @RequestParam("endTime")long endTime,
                               @ApiParam(value = "页数") @RequestParam(required = false) Integer pageNum,
                               @ApiParam(value ="每页大小 默认100") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 100;
        }
        return tbCfOrderService.getOrderListByTime(beginTime,endTime,pageNum,pageSize);
    }

       /**
     *获取某段时间已发货订单数据
     */
    @ApiOperation(value = "获取某段时间已发货订单数据")
    @GetMapping(value ="/delivery")
    public Result getDeliveryList(@ApiParam(value ="开始时间") @RequestParam("beginTime")long beginTime,
                                  @ApiParam(value ="结束时间") @RequestParam("endTime")long endTime,
                                  @ApiParam(value = "页数") @RequestParam(required = false) Integer pageNum,
                                  @ApiParam(value ="每页大小 默认100") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 100;
        }
        return tbCfOrderService.getDeliveryList(beginTime,endTime,pageNum,pageSize);
    }

    /**
     * 根据订单号获取详细订单数据
     */
    @ApiOperation(value = "根据订单号获取详细订单数据")
    @GetMapping(value ="/order/detail/{orderId}")
    public Result getOrderDetailThird(@PathVariable("orderId")String orderId) {
        return tbCfOrderService.getOrderDetailThird(orderId);
    }
    /**
     * 获取用户列表
     */
    @ApiOperation(value = "获取用户列表")
    @GetMapping(value ="/user")
    public Result getAllUser( @ApiParam(value = "页数") @RequestParam(required = false) Integer pageNum,
                                                @ApiParam(value ="每页大小 默认100") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 100;
        }
        return tbCfUserInfoService.queryUserList(pageNum,pageSize);
    }
}
