package com.diaoyun.zion.master.util;

import com.diaoyun.zion.chinafrica.constant.KeyConstant;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class SpiderUtil {

    /**
     * 格式化 gap 返回数据
     *
     * @param dataMap
     * @return
     */
    public static ProductResponse formatGapProductResponse(JSONObject dataMap) {
        ProductResponse productResponse = new ProductResponse();
        //原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        //促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        Map<String, Set<ProductProp>> productPropSet=new HashMap<>();
        JSONArray productList=dataMap.getJSONArray("productList");
        //商品信息
        ItemInfo itemInfo =new ItemInfo();
        for (int index = 0; index < productList.size(); index++) {
            JSONObject propObj=productList.getJSONObject(index);
            //////////////////获取价格//////////////////
            JSONArray skuList = propObj.getJSONArray("skuList");
            for (int i = 0; i < skuList.size(); i++) {
                JSONObject skuValue = skuList.getJSONObject(i);
                JSONArray attrSaleList=skuValue.getJSONArray("attrSaleList");
                String skuStr=";";
                for(int m=0;m<attrSaleList.size();m++) {
                    JSONObject attrSale=attrSaleList.getJSONObject(m);
                    JSONArray attributeValueList=attrSale.getJSONArray("attributeValueList");
                    skuStr=skuStr+attributeValueList.getJSONObject(0).getString("code")+";";
                }
                //原始价格
                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(skuValue.getString("listPrice"));
                originalPriceList.add(originalPrice);
                //促销价格
                if(StringUtils.isNotBlank(skuValue.getString("salePrice"))) {
                    productResponse.setPromotionFlag(true);
                    ProductPromotion productPromotion = new ProductPromotion();
                    productPromotion.setSkuStr(skuStr);
                    productPromotion.setPrice(skuValue.getString("salePrice"));
                    promotionList.add(productPromotion);
                }

            }
            //////////////////获取价格 END//////////////////
            //////////////////获取商品属性//////////////////
            JSONArray attrSaleList = propObj.getJSONArray("attrSaleList");
            for(int i=0;i<attrSaleList.size();i++) {
                JSONArray attributeValueList = attrSaleList.getJSONObject(i).getJSONArray("attributeValueList");
                //商品属性
                Set<ProductProp> propSet=new HashSet<>();
                for(int j=0;j<attributeValueList.size();j++) {
                    ProductProp productProp=new ProductProp();
                    //获取图片，拿第一张
                    if(attributeValueList.getJSONObject(j).get("itemAttributeValueImageList")!=null&&!"null".equalsIgnoreCase(attributeValueList.getJSONObject(j).getString("itemAttributeValueImageList"))) {
                        JSONArray itemAttributeValueImageList =attributeValueList.getJSONObject(j).getJSONArray("itemAttributeValueImageList");
                        productProp.setImage(itemAttributeValueImageList.getJSONObject(0).getString("picUrl"));
                    }
                    productProp.setPropName(attributeValueList.getJSONObject(j).getString("attributeValueName"));
                    productProp.setPropId(attributeValueList.getJSONObject(j).getString("code"));
                    propSet.add(productProp);
                }
                String attributeFrontName=attrSaleList.getJSONObject(i).getString("attributeFrontName");
                if(productPropSet.get(attributeFrontName)==null) {
                    productPropSet.put(attributeFrontName,propSet);
                } else {
                    Set<ProductProp> oldPropSet=productPropSet.get(attributeFrontName);
                    propSet.addAll(oldPropSet);
                    productPropSet.put(attributeFrontName,propSet);
                }

            }

            //////////////////获取商品属性 END//////////////////

            itemInfo.setItemId(propObj.getString("style"));
            JSONArray itemImageList=propObj.getJSONArray("itemImageList");
            if(!itemImageList.isEmpty()) {
                String pic=itemImageList.getJSONObject(0).getString("picUrl");
                //取第一张当作主图
                itemInfo.setPic(pic);
            }
            itemInfo.setShopName(PlatformEnum.GAP.getLabel());
            itemInfo.setShopUrl("https://www.gap.cn/");
            itemInfo.setTitle(propObj.getString("title"));

        }



        //一口价
        productResponse.setPrice(dataMap.getString("minPrice")+"-"+dataMap.getString("maxPrice"));
        //一口价
        productResponse.setSalePrice(dataMap.getString("minPrice")+"-"+dataMap.getString("maxPrice"));
        //没有库存信息 需要另外获取
        productResponse.setStockFlag(false);
        //有商品属性
        productResponse.setPropFlag(true);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setPromotionList(promotionList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setPlatform(PlatformEnum.GAP.getValue());
        productResponse.setProductPropSet(productPropSet);
        return productResponse;
    }
    /**
     * 格式化 nike 返回数据
     *
     * @param dataMap
     * @return
     */
    public static ProductResponse formatNikeProductResponse(JSONObject dataMap) {
        ProductResponse productResponse = new ProductResponse();
        //nike 基本是 颜色、尺码属性
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>();
        //原始价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        //促销价格
        List<ProductPromotion> promotionList = new ArrayList<>();
        //库存
        DynStock dynStock = new DynStock();
        //其实数据没有包含确切的库存数，这里默认给足量的库存
        dynStock.setSellableQuantity(9999);
        //商品基本信息
        ItemInfo itemInfo = new ItemInfo();
        JSONObject threadObj=dataMap.getJSONObject("Threads");
        JSONObject productsObj=threadObj.getJSONObject("products");
        Set es = productsObj.entrySet();
        Iterator it = es.iterator();
        while(it.hasNext()) {
            Map.Entry<String,JSONObject> entry = (Map.Entry) it.next();
            String skuStr=";";
            String modelCode = entry.getKey();
            skuStr=skuStr+modelCode+";";
            JSONObject itemDetail = entry.getValue();
            ////////////////////////////////////获取价格和商品属性////////////////////////////////////////////
            String fullPrice =itemDetail.getString("fullPrice");
            String currentPrice =itemDetail.getString("currentPrice");
            productResponse.setPrice(currentPrice);
            JSONArray skusArr=itemDetail.getJSONArray("skus");
            //获取商品尺码属性，同时记录下skuid和尺码关系
            Map<String,String> sizeSkuIdMapping=new HashMap<>();
            for(int i=0;i<skusArr.size();i++) {
                String skuId=skusArr.getJSONObject(i).getString("skuId");
                /////////////////////////获取商品尺码属性////////////////////
                //商品属性
                Set<ProductProp> sizePropSet=new HashSet<>();
                ProductProp productProp = new ProductProp();
                String localizedSize=skusArr.getJSONObject(i).getString("localizedSize");
                String localizedSizePrefix=skusArr.getJSONObject(i).getString("localizedSizePrefix");
                //因为尺码一样的时候skuid却不一样，这里只能赋予一个propid，否则后面去重不了
                String customizeId= KeyConstant.CUSTOMIZE_ID +localizedSize+localizedSizePrefix;
                sizeSkuIdMapping.put(skuId,customizeId);
                productProp.setPropId(customizeId);
                productProp.setPropName(localizedSizePrefix+" "+localizedSize);
                sizePropSet.add(productProp);
                if(productPropSet.get("尺码")==null) {
                    productPropSet.put("尺码",sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet=productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码",sizePropSet);
                }
                /////////////////////////获取商品尺码属性 END////////////////////

            }

            ////////////////////////////////////获取价格//////////////////////////////////
            for(int i=0;i<skusArr.size();i++) {
                String skuId=skusArr.getJSONObject(i).getString("skuId");
                String customizeId=sizeSkuIdMapping.get(skuId);
                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr + customizeId + ";");
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);
                if (itemDetail.getBoolean("discounted")) {
                    productResponse.setPromotionFlag(true);
                    productResponse.setSalePrice(currentPrice);
                    ProductPromotion productPromotion = new ProductPromotion();
                    productPromotion.setSkuStr(skuStr + customizeId + ";");
                    productPromotion.setPrice(currentPrice);
                    promotionList.add(productPromotion);
                }
            }
            ////////////////////////////////////获取价格 END//////////////////////////////////

            /////////////////////////////////////获取价格和商品属性 END////////////////////////////////////////////
            ////////////////////////////////////获取库存 ////////////////////////////////////////////
            productResponse.setStockFlag(true);
            List<ProductSkuStock> productSkuStockList =dynStock.getProductSkuStockList();
            if(productSkuStockList==null) {
                productSkuStockList=new ArrayList<>();
            }
            JSONArray availableSkusArr=itemDetail.getJSONArray("availableSkus");
            for(int i=0;i<availableSkusArr.size();i++) {
                String skuId=availableSkusArr.getJSONObject(i).getString("skuId");
                String customizeId=sizeSkuIdMapping.get(skuId);
                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSellableQuantity(999);
                productSkuStock.setSkuStr(skuStr+customizeId+";");
                productSkuStockList.add(productSkuStock);
            }
            dynStock.setProductSkuStockList(productSkuStockList);

            ////////////////////////////////////获取库存 END////////////////////////////////////////////
            ////////////////////////////////////获取商品颜色属性////////////////////////////////////////////
            //商品属性
            Set<ProductProp> propSet=new HashSet<>();
            ProductProp productProp = new ProductProp();
            String colorDescription=itemDetail.getString("colorDescription");
            String firstImageUrl=itemDetail.getString("firstImageUrl");
            productProp.setPropId(modelCode);
            productProp.setPropName(colorDescription);
            productProp.setImage(firstImageUrl);
            propSet.add(productProp);
            if(productPropSet.get("颜色")==null) {
                productPropSet.put("颜色",propSet);
            } else {
                Set<ProductProp> oldPropSet=productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色",propSet);
            }
            ////////////////////////////////////获取商品属性 END////////////////////////////////////////////
        }
        JSONObject globalObj=dataMap.getJSONObject("global");
        JSONObject metaTagsObj=globalObj.getJSONObject("metaTags");
        JSONArray metaArr=metaTagsObj.getJSONArray("meta");
        for(int i=0;i<metaArr.size();i++) {
            if(metaArr.getJSONObject(i).get("property")!=null) {
                String propertyValue=metaArr.getJSONObject(i).getString("property");
                if("og:title".equalsIgnoreCase(propertyValue)) {
                    itemInfo.setTitle(metaArr.getJSONObject(i).getString("content"));
                }
                if("og:image".equalsIgnoreCase(propertyValue)) {
                    itemInfo.setPic(metaArr.getJSONObject(i).getString("content"));
                }
            }
        }
        itemInfo.setShopUrl("https://www.nike.com/cn/");
        itemInfo.setShopName(PlatformEnum.NIKE.getLabel());
        productResponse.setPropFlag(true);
        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform(PlatformEnum.NIKE.getValue());
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}
