package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfHomePageEntity;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 启动页Service接口
 *
 * @author lipengjun
 * @date 2019-09-16 18:21:16
 */
public interface TbCfHomePageService {

    /**
     * 根据主键查询实体
     *
     * @param pageId 主键
     * @return 实体
     */
    TbCfHomePageEntity queryObject(String pageId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfHomePageEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfHomePage 实体
     * @return 保存条数
     */
    int save(TbCfHomePageEntity tbCfHomePage);

    /**
     * 根据主键更新实体
     *
     * @param tbCfHomePage 实体
     * @return 更新条数
     */
    int update(TbCfHomePageEntity tbCfHomePage);

    /**
     * 根据主键删除
     *
     * @param pageId
     * @return 删除条数
     */
    int delete(String pageId);

    /**
     * 根据主键批量删除
     *
     * @param pageIds
     * @return 删除条数
     */
    int deleteBatch(String[] pageIds);

    /**
     * 获取有效的启动页图片
     * @return
     */
    Result getStartPageImage();
}
