package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.TbCfStationItemService;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 站点商品Controller
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
@Api(tags="商品独立站")
@RestController
@RequestMapping("/itemStation")
public class TbCfStationItemController {
    @Autowired
    private TbCfStationItemService tbCfStationItemService;

    @ApiOperation("获取商品独立站")
    @GetMapping
    public Result getItemStationList(@ApiParam(value = "页数 默认1") @RequestParam(required = false) Integer pageNum,
                                  @ApiParam(value ="每页大小 默认10") @RequestParam(required = false) Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        return tbCfStationItemService.getItemStationList(pageNum,pageSize);
    }

}
