package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfExpressTemplateDao;
import com.diaoyun.zion.chinafrica.entity.TbCfExpressTemplateEntity;
import com.diaoyun.zion.chinafrica.service.TbCfExpressTemplateService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 运费模板Service实现类
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Service("tbCfExpressTemplateService")
public class TbCfExpressTemplateServiceImpl implements TbCfExpressTemplateService {
    @Autowired
    private TbCfExpressTemplateDao tbCfExpressTemplateDao;

    @Override
    public TbCfExpressTemplateEntity queryObject(String templateId) {
        return tbCfExpressTemplateDao.queryObject(templateId);
    }

    @Override
    public List<TbCfExpressTemplateEntity> queryList(Map<String, Object> map) {
        return tbCfExpressTemplateDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfExpressTemplateDao.queryTotal(map);
    }

    @Override
    public int save(TbCfExpressTemplateEntity tbCfExpressTemplate) {
        tbCfExpressTemplate.setTemplateId(IdUtil.createIdbyUUID());
        return tbCfExpressTemplateDao.save(tbCfExpressTemplate);
    }

    @Override
    public int update(TbCfExpressTemplateEntity tbCfExpressTemplate) {
        return tbCfExpressTemplateDao.update(tbCfExpressTemplate);
    }

    @Override
    public int delete(String templateId) {
        return tbCfExpressTemplateDao.delete(templateId);
    }

    @Override
    public int deleteBatch(String[] templateIds) {
        return tbCfExpressTemplateDao.deleteBatch(templateIds);
    }
}
