package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.bis.impl.NetWorkSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.factory.ItemSpiderFactory;
import com.diaoyun.zion.chinafrica.service.SpiderService;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.stereotype.Service;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

@Service("spiderService")
public class SpiderServiceImpl implements SpiderService {

    @Override
    public JSONObject getItemDetail(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException, TimeoutException {

        //判断链接属于哪个平台
        PlatformEnum platformEnum=judgeUrlType(targetUrl);
        IItemSpider iItemSpider=ItemSpiderFactory.getSpider(platformEnum);
        return iItemSpider.captureItem(targetUrl);
    }

    @Override
    public BigDecimal getExchangeRate(String currency) throws IOException, URISyntaxException {

        //默认人民币换美元
        if(StringUtils.isBlank(currency)) {
            currency="FOREXUSDCNY";
        }
        return NetWorkSpider.getRateFromHexun(currency);
    }

    private PlatformEnum judgeUrlType(String targetUrl) {
        PlatformEnum platformEnum = PlatformEnum.UN;
        if(targetUrl.contains("taobao.com")&&(targetUrl.contains("item.htm")||targetUrl.contains("detail.htm"))) {
            platformEnum=PlatformEnum.TB;
        } else if(targetUrl.contains("tmall.com/item.htm")) {
            platformEnum=PlatformEnum.TM;
        } else if(targetUrl.contains("www.gap.cn/pdp/")) {
            platformEnum=PlatformEnum.GAP;
        } else if(targetUrl.contains("www.nike.com/cn/t/")) {
            platformEnum=PlatformEnum.NIKE;
        } else if(targetUrl.contains("www.afri-eshop.com")&&targetUrl.contains("/products/")) {
            platformEnum=PlatformEnum.AfriEshop;
        } else if (targetUrl.contains("zara.cn")) {
            platformEnum = platformEnum.ZARA;
        } else if (targetUrl.contains("uniqlo.cn/product-detail.html")) {
            platformEnum = platformEnum.UNIQLO;
        }
        return platformEnum;
    }
}
