package com.diaoyun.zion.chinafrica.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠券表实体
 * 表名 tb_cf_coupon
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@ApiModel
public class TbCfCouponEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 优惠券id
     */
    @ApiModelProperty("优惠券id")
    private String couponId;
    /**
     * 优惠券类型
     */
    @ApiModelProperty("优惠券类型")
    private Integer couponCategory;
    /**
     * 可用于类目
     */
    @ApiModelProperty("可用于类目（暂无用）")
    private Integer couponUse;
    /**
     * 优惠券标题
     */
    @ApiModelProperty("优惠券标题")
    private String couponTitle;
    /**
     * 优惠券图片地址
     */
    @ApiModelProperty("优惠券图片地址")
    private String couponIcon;
    /**
     * 那些站点可以使用,1111为全部
     */
    @ApiModelProperty("哪些站点可以使用（暂无用）")
    private String withStationId;
    /**
     * 满多少金额可以使用
     */
    @ApiModelProperty("满多少金额可以使用")
    private BigDecimal withAmount;
    /**
     * 抵扣金额
     */
    @ApiModelProperty("抵扣金额")
    private BigDecimal deductAmount;
    /**
     * 发券数量
     */
    @ApiModelProperty("发券数量")
    private Integer quato;
    /**
     * 已领取数量 不更改，因为会被覆盖，改为查询统计来获取已经领取的优惠券数量
     */
    @ApiModelProperty("已领取数量（暂无用）")
    private Integer takeCount;
    /**
     * 已使用数量 不更改，因为会被覆盖，改为查询统计来获取已经使用的优惠券数量
     */
    @ApiModelProperty("已使用数量（暂无用）")
    private Integer usedCount;
    /**
     * 发放开始时间
     */
    @ApiModelProperty("发放开始时间")
    private Date startTime;
    /**
     * 发放结束时间
     */
    @ApiModelProperty("发放结束时间")
    private Date endTime;
    /**
     * 有效开始时间
     */
    @ApiModelProperty("有效开始时间")
    private Date validStartTime;
    /**
     * 有效结束时间
     */
    @ApiModelProperty("有效结束时间")
    private Date validEndTime;
    /**
     * 有效标志,0无效,1生效,2过期
     */
    @ApiModelProperty("有效标志,0无效,1生效,2过期,暂没完全使用")
    private Integer status;
    /**
     * 创建人
     */
    @ApiModelProperty("创建人")
    private String createUserId;
    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;
    /**
     * 修改人
     */
    @ApiModelProperty("修改人")
    private String updateUserId;
    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date updateTime;

    /**
     * 设置：优惠券id
     */
    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    /**
     * 获取：优惠券id
     */
    public String getCouponId() {
        return couponId;
    }
    /**
     * 设置：优惠券类型
     */
    public void setCouponCategory(Integer couponCategory) {
        this.couponCategory = couponCategory;
    }

    /**
     * 获取：优惠券类型
     */
    public Integer getCouponCategory() {
        return couponCategory;
    }
    /**
     * 设置：可用于
     */
    public void setCouponUse(Integer couponUse) {
        this.couponUse = couponUse;
    }

    /**
     * 获取：可用于
     */
    public Integer getCouponUse() {
        return couponUse;
    }
    /**
     * 设置：优惠券标题
     */
    public void setCouponTitle(String couponTitle) {
        this.couponTitle = couponTitle;
    }

    /**
     * 获取：优惠券标题
     */
    public String getCouponTitle() {
        return couponTitle;
    }
    /**
     * 设置：优惠券图片地址
     */
    public void setCouponIcon(String couponIcon) {
        this.couponIcon = couponIcon;
    }

    /**
     * 获取：优惠券图片地址
     */
    public String getCouponIcon() {
        return couponIcon;
    }
    /**
     * 设置：那些站点可以使用,1111为全部
     */
    public void setWithStationId(String withStationId) {
        this.withStationId = withStationId;
    }

    /**
     * 获取：那些站点可以使用,1111为全部
     */
    public String getWithStationId() {
        return withStationId;
    }
    /**
     * 设置：满多少金额可以使用
     */
    public void setWithAmount(BigDecimal withAmount) {
        this.withAmount = withAmount;
    }

    /**
     * 获取：满多少金额可以使用
     */
    public BigDecimal getWithAmount() {
        return withAmount;
    }
    /**
     * 设置：抵扣金额
     */
    public void setDeductAmount(BigDecimal deductAmount) {
        this.deductAmount = deductAmount;
    }

    /**
     * 获取：抵扣金额
     */
    public BigDecimal getDeductAmount() {
        return deductAmount;
    }
    /**
     * 设置：发券数量
     */
    public void setQuato(Integer quato) {
        this.quato = quato;
    }

    /**
     * 获取：发券数量
     */
    public Integer getQuato() {
        return quato;
    }
    /**
     * 设置：已领取数量
     */
    public void setTakeCount(Integer takeCount) {
        this.takeCount = takeCount;
    }

    /**
     * 获取：已领取数量
     */
    public Integer getTakeCount() {
        return takeCount;
    }
    /**
     * 设置：已使用数量
     */
    public void setUsedCount(Integer usedCount) {
        this.usedCount = usedCount;
    }

    /**
     * 获取：已使用数量
     */
    public Integer getUsedCount() {
        return usedCount;
    }
    /**
     * 设置：发放开始时间
     */
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 获取：发放开始时间
     */
    public Date getStartTime() {
        return startTime;
    }
    /**
     * 设置：发放结束时间
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取：发放结束时间
     */
    public Date getEndTime() {
        return endTime;
    }
    /**
     * 设置：有效开始时间
     */
    public void setValidStartTime(Date validStartTime) {
        this.validStartTime = validStartTime;
    }

    /**
     * 获取：有效开始时间
     */
    public Date getValidStartTime() {
        return validStartTime;
    }
    /**
     * 设置：有效结束时间
     */
    public void setValidEndTime(Date validEndTime) {
        this.validEndTime = validEndTime;
    }

    /**
     * 获取：有效结束时间
     */
    public Date getValidEndTime() {
        return validEndTime;
    }
    /**
     * 设置：有效标志,0无效,1生效,2过期
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取：有效标志,0无效,1生效,2过期
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置：创建人
     */
    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * 获取：创建人
     */
    public String getCreateUserId() {
        return createUserId;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：修改人
     */
    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    /**
     * 获取：修改人
     */
    public String getUpdateUserId() {
        return updateUserId;
    }
    /**
     * 设置：修改时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：修改时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
