package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.master.util.HttpClientUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 优衣库数据爬虫
 *
 * TODO 图片路径未处理
 * 图片路径为："https://www.uniqlo.cn/hmall/test/" + 商品id + "/sku/40/" + 商品图片id + ".jpg"
 */
@Component("uniqloSpider")
public class UniqloSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(UniqloSpider.class);

    // 优衣库数据爬虫
    private static final String uniqloUrl = "https://www.uniqlo.cn/data/products/spu/";

    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        // 获取商品 id
        String[] split = targetUrl.split("productCode=");
        String pId = split[1];
        // 获取商品详情的json链接
        targetUrl = uniqloUrl + "zh_CN/" + pId + ".json";
        // 获取网页内容
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.UNIQLO.getValue());
        // 转换为 json
        JSONObject json = JSONObject.fromObject(content);
        // 商品id
        String pName = json.getJSONObject("summary").getString("name");
        // 商品价格
        String pPrice = json.getJSONObject("summary").getString("originPrice");
        // 格式化数据
        JSONArray rowsJson = json.getJSONArray("rows");
        JSONObject returnJson = new JSONObject();
        returnJson.put("name", pName);
        returnJson.put("price", pPrice);
        returnJson.elementOpt("data", rowsJson);
        return returnJson;
    }

}
