package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.ProductResponse;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.JsoupUtil;
import com.diaoyun.zion.master.util.SpiderUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * afri-eshop 数据爬虫
 */
@Component("africaShopItemSpider")
public class AfricaShopItemSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(AfricaShopItemSpider.class);

    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, InterruptedException, ExecutionException, TimeoutException {
        JSONObject resultObj;
        //获取url中的网页内容 >
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.AfriEshop.getValue());
        //获取商品相关信息，详情放在<script> 标签里  <script type="application/json" id="ProductJson-product-template">
        resultObj = JsoupUtil.getScriptContentById(content, "ProductJson-product-template");
        //格式化为封装数据
        ProductResponse productResponse = SpiderUtil.formatAfricaShopProductResponse(resultObj);
        resultObj = JSONObject.fromObject(productResponse);
        //翻译
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }


}
