$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfstore/list',
        colModel: [
			{label: 'storeId', name: 'storeId', index: 'store_id', key: true, hidden: true},
			{label: '店铺编号', name: 'storeCode', index: 'store_code', width: 80},
			{label: '店铺名字', name: 'storeName', index: 'store_name', width: 80},
			{label: '店铺简介', name: 'storeBrief', index: 'store_brief', width: 80},
			{label: '店铺链接', name: 'storeUrl', index: 'store_url', width: 80,formatter:linkFormat},
			{label: '主营商品图片', name: 'itemImg2', index: 'item_img_2', width: 80,formatter:imageFormat},
			{label: '主营商品图片', name: 'itemImg1', index: 'item_img_1', width: 80,formatter:imageFormat},
			{label: '店铺图片', name: 'storeImg', index: 'store_img', width: 80,formatter:imageFormat},
			{label: '所属平台', name: 'platformCode', index: 'platform_code', width: 80},
			{label: '平台名', name: 'platformName', index: 'platform_name', width: 80},
			{label: '启用状态', name: 'enableFlag', index: 'enable_flag', width: 80},
			{label: '创建日期', name: 'createTime', index: 'create_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfStore: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfStore = {};
		},
		update: function (event) {
            let storeId = getSelectedRow("#jqGrid");
			if (storeId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(storeId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfStore.storeId == null ? "../tbcfstore/save" : "../tbcfstore/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfStore),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let storeIds = getSelectedRows("#jqGrid");
			if (storeIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfstore/delete",
                    params: JSON.stringify(storeIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(storeId){
            Ajax.request({
                url: "../tbcfstore/info/"+storeId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfStore = r.tbCfStore;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        },
		tirggerFile : function (event) {
			var file = event.target.files[0]; // (利用console.log输出看file文件对象)
			var formData = new FormData();
			formData.append("file",file);
			$.ajax({
				url: "../api/upload/image/",
				type: "POST",
				data:formData,
				cache:false,         //不设置缓存
				processData: false,  // 不处理数据
				contentType: false,// 不设置内容类型
				success: function (result) {
					result=JSON.parse(result);
					//console.log(result)
					if (result.errno == 0) {//成功
						vm.tbCfStore.itemImg2=result.data;
						vm.$forceUpdate();
					} else {
						iview.Message.error(result.errmsg);
					}
				}
			});
		},
		tirggerFile1 : function (event) {
			var file = event.target.files[0]; // (利用console.log输出看file文件对象)
			var formData = new FormData();
			formData.append("file",file);
			$.ajax({
				url: "../api/upload/image/",
				type: "POST",
				data:formData,
				cache:false,         //不设置缓存
				processData: false,  // 不处理数据
				contentType: false,// 不设置内容类型
				success: function (result) {
					result=JSON.parse(result);
					//console.log(result)
					if (result.errno == 0) {//成功
						vm.tbCfStore.itemImg1=result.data;
						vm.$forceUpdate();
					} else {
						iview.Message.error(result.errmsg);
					}
				}
			});
		},
		tirggerStore : function (event) {
			var file = event.target.files[0]; // (利用console.log输出看file文件对象)
			var formData = new FormData();
			formData.append("file",file);
			$.ajax({
				url: "../api/upload/image/",
				type: "POST",
				data:formData,
				cache:false,         //不设置缓存
				processData: false,  // 不处理数据
				contentType: false,// 不设置内容类型
				success: function (result) {
					result=JSON.parse(result);
					//console.log(result)
					if (result.errno == 0) {//成功
						vm.tbCfStore.storeImg=result.data;
						vm.$forceUpdate();
					} else {
						iview.Message.error(result.errmsg);
					}
				}
			});
		}
	}
});