$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfstationstatistic/list',
        colModel: [
			{label: 'statisticId', name: 'statisticId', index: 'statistic_id', key: true, hidden: true},
			{label: '站点id', name: 'stationId', index: 'station_id', width: 80},
			{label: '站点名字', name: 'stationName', index: 'station_name', width: 80},
			{label: '站点销量', name: 'stationSales', index: 'station_sales', width: 80},
			{label: '销售额', name: 'salesVolume', index: 'sales_volume', width: 80},
			{label: '点击量', name: 'clicks', index: 'clicks', width: 80},
			{label: '统计时间', name: 'statisticTime', index: 'statistic_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfStationStatistic: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfStationStatistic = {};
		},
		update: function (event) {
            let statisticId = getSelectedRow("#jqGrid");
			if (statisticId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(statisticId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfStationStatistic.statisticId == null ? "../tbcfstationstatistic/save" : "../tbcfstationstatistic/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfStationStatistic),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let statisticIds = getSelectedRows("#jqGrid");
			if (statisticIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfstationstatistic/delete",
                    params: JSON.stringify(statisticIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(statisticId){
            Ajax.request({
                url: "../tbcfstationstatistic/info/"+statisticId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfStationStatistic = r.tbCfStationStatistic;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});