$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfproblem/list',
        colModel: [
			{label: 'problemId', name: 'problemId', index: 'problem_id', key: true, hidden: true},
			{label: '问题明细', name: 'question', index: 'question', width: 80},
			{label: '答案', name: 'answer', index: 'answer', width: 80,formatter:contentFormat},
			{label: '是否展示', name: 'enableFlag', index: 'enable_flag', width: 80},
			{label: '排序', name: 'sort', index: 'sort', width: 80},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80}]
    });
});


/**
 * 增加修改的编辑器
 * @type {UE.ui.Editor|*}
 */
var ue = UE.getEditor('container');
/**
 * 获取文本框内容
 * @returns {*|String|void}
 */
function getContent() {
	var htmlContent = ue.getContent();
	return htmlContent;
}
/**
 * 显示内容
 * @param content
 */
function showContent(problemId) {
	$('#contentModal').modal('show');
	vm.getInfo(problemId,true);
};


let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfProblem: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfProblem = {};
		},
		update: function (event) {
            let problemId = getSelectedRow("#jqGrid");
			if (problemId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(problemId);
		},
		saveOrUpdate: function (event) {
			var answer=getContent();
			vm.tbCfProblem.answer=encodeURI(answer);
            let url = vm.tbCfProblem.problemId == null ? "../tbcfproblem/save" : "../tbcfproblem/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfProblem),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
						ue.setContent("");
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let problemIds = getSelectedRows("#jqGrid");
			if (problemIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfproblem/delete",
                    params: JSON.stringify(problemIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(problemId,isShowDetail){
            Ajax.request({
                url: "../tbcfproblem/info/"+problemId,
                async: true,
                successCallback: function (r) {
                	console.log(r)
					r.tbCfProblem.answer=decodeURI(r.tbCfProblem.answer);
                    vm.tbCfProblem = r.tbCfProblem;
					ue.setContent(vm.tbCfProblem.answer);
					if(!!isShowDetail) {
						var answer="无内容，请点击修改，添加内容";
						if(!!vm.tbCfProblem.answer) {
							answer=vm.tbCfProblem.answer;
						}
						$("#contentContainer").html(answer);
					}
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});