$(function () {
    $("#jqGrid").Grid({
        url: '../tbcforder/orderList',
        //colNames: ['orderId', 'itemId', '用户id', '订单号', '下单时间', '金额', '商品', '商品数量', '收货地址', '快递单号', '支付方式', '物流状态'],
      /*  cellEdit: true,
        cellsubmit: "remote",
        cellurl:'../tbcforder/changeDeliveryFlag/',*/
        colModel: [
            //显示字段
            {label: 'orderId', name: 'orderId', index: 'order_id', key: true, hidden: true},
            {label: 'itemId', name: 'itemId', index: 'item_id', key: true, hidden: true},
            {label: '用户id', name: 'userId', index: 'user_id', width: 120},
            {label: '订单号', name: 'orderNo', index: 'order_no', width: 80},
            {label: '下单时间', name: 'orderTime', index: 'order_time', width: 70},
            {label: '金额',name:  'realityPay', index: 'reality_pay', width: 45},
               // formatter: "currency",formatoptions: {thousandsSeparator:",",decimalSeparator:".",decimalPlaces:"2", prefix:"$"}}, //在金额前加上$,加上后，页合计无法正常显示。
            {label: '商品', name: 'itemTitle', index: 'item_title', width: 90},
            {label: '商品数量', name: 'itemNum', index: 'item_num', width: 30},
            {label: '收货地址', name: 'deliveryAddress', index: 'delivery_address', width: 100},
            {label: '快递单号', name: 'pExpressNumber', index: 'p_express_number', width: 80,sortable:false},
            {label: '支付方式', name: 'payWayCode', index: 'pay_way_code', width: 35},
            {label: '物流状态', name: 'deliveryFlag', index: 'delivery_flag', width: 40,formatter:deliveryFlagFormat},
            {label: '代购人', name: 'userName', index: 'user_name', width: 40},
            {label: '总金额', name: 'totalPay', index: 'totalPay', width: 40,hidden:true}
               /* , editable:true,edittype:'select',editoptions:{value:{
                0:'等待处理', 10:'已经代购', 20:'正在配送', 30:'已到达中国仓', 40:'正运往非洲',50:'买家已签收'}*/
        ],
        footerrow: true,
        gridComplete:function(){
            // 页合计
            let rowNum = parseInt($(this).getGridParam('records'),10);
           // let totalPay= $(this).getGridParam('totalSum');
            if (rowNum > 0) {
                $(".ui-jqgrid-sdiv").show();
                let realityPay = jQuery(this).getCol('realityPay', false, 'sum');
                //let totalPay = jQuery(this).getCol('realityPay', false, 'sum');
                $(this).footerData("set", {
                    "orderTime": "<font color='red'>页合计<font>",
                    "realityPay": "<font color='red'>"+"$" + realityPay.toFixed(2) + "<font>",
                  /*  "itemNum": "<font color='red'>总合计<font>",
                    "deliveryAddress": "<font color='red'>"+"$" + totalPay.toFixed(2) + "<font>",*/
                });
            } else {
                $(".ui-jqgrid-sdiv").hide();
            }
        }
    });
});

let vm = new Vue({
    el: '#rrapp',
    data: {
        showList: true,
        title: null,
        tbCfOrderList: {},
        deliveryFlagOptions:[{
            value: '0',
            label: '等待处理'
        },{
            value: '10',
            label: '已代购'
        },{
            value: '20',
            label: '已到达中国仓'
        },{
            value: '30',
            label: '正运往非洲'
        },{
            value: '40',
            label: '已到达非洲仓'
        },{
            value: '50',
            label: '买家已签收'
        }],
        payWayCodeOptions:[{
            value:'stripe',
            label:'stripe',
        },{
            value:'paypal',
            label:'paypal',
        },{
            value:'flutterWave',
            label:'flutterWave',
        }],
        deliveryFlag:'',
        payWayCode:'',
        pickerOptions: {
            shortcuts: [{
                text: '最近一周',
                onClick(picker) {
                    const end = new Date();
                    const start = new Date();
                    start.setTime(start.getTime() - 3600 * 1000 * 24 * 7);
                    picker.$emit('pick', [start, end]);
                }
            }, {
                text: '最近一个月',
                onClick(picker) {
                    const end = new Date();
                    const start = new Date();
                    start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
                    picker.$emit('pick', [start, end]);
                }
            }, {
                text: '最近三个月',
                onClick(picker) {
                    const end = new Date();
                    const start = new Date();
                    start.setTime(start.getTime() - 3600 * 1000 * 24 * 90);
                    picker.$emit('pick', [start, end]);
                }
            }]
        },
        ruleValidate: {
            name: [
                {required: true, message: '名称不能为空', trigger: 'blur'}
            ]
        },
        orderId:'',
        orderNo:'',
        value:'',
    },
    methods: {
        queryAll: function () {
            vm.reload();
        },
        handleCommand:function(value){
               alert('click on item ' + value);
        },
      /*  handlePayCode:function(value){
            debugger;
            Ajax.request({
                url: "../tbcforder/orderList?pay=" + value,
                async: true,
                successCallback: function (r) {
                    vm.tbCfOrderList = r.tbCfOrderList;
                }
            });
        },*/
       /* saveOrUpdate: function (event) {
            let url = vm.tbCfOrderList.orderId == null ? "../tbcforder/save" : "../tbcforder/update";
            Ajax.request({
                url: url,
                params: JSON.stringify(vm.tbCfOrderList),
                type: "POST",
                contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
            });
        },*/
        /*del: function (event) {
            let orderIds = getSelectedRows("#jqGrid");
            if (orderIds == null) {
                return;
            }
            confirm('确定要删除选中的记录？', function () {
                Ajax.request({
                    url: "../tbcforder/delete",
                    params: JSON.stringify(orderIds),
                    type: "POST",
                    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
                    }
                });
            });
        },*/
       /* getInfo: function (orderId) {
            Ajax.request({
                url: "../tbcforder/info/" + orderId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfOrderList = r.tbCfOrderList;
                }
            });
        },*/
        reload: function (event) {
            vm.showList = true;
            let start=vm.value[0];
            let end=vm.value[1];
            let payWayCode=vm.payWayCode;
            let deliveryFlag=vm.deliveryFlag;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
            $("#jqGrid").jqGrid('setGridParam', {
                postData: {'name':vm.orderNo,'start':start,'end':end,'payWayCode':payWayCode,'deliveryFlag':deliveryFlag},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
        },
        reloadSearch: function() {
            vm.deliveryFlag='';
            vm.orderNo='';
            vm.value='';
            vm.payWayCode='';
            vm.expressStatus = '';
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
    }
});

