$(function () {
    $("#jqGrid").Grid({
        url: '../tbcforder/list',
       /* colNames: ['orderId','订单号','用户编号','用户昵称','订单创建时间','商品品名','实际付款','收货地址','快递单号','快递状态','支付状态',
            '代购状态','代购人','代购时间','操作', '更新时间','成交时间','交易关闭时间','订单状态','用户id','用户名','收货地址Id','收货地址','收货人','收货人手机',
            '商品品名','商品总价','总价','实际付款','代购标志', '代购时间','快递费','优惠券id','优惠券标题','优惠券减免价格','税费','手续费','交易号','支付状态',
        ],*/
        colModel: [
            //显示字段
            {label: 'orderId', name: 'orderId', index: 'order_id', key: true, hidden: true},
            {label: '订单号', name: 'orderNo', index: 'order_no', width: 120},
            {label: '订单创建时间', name: 'orderTime', index: 'order_time', width: 90},
            {label: '支付状态', name: 'payStatus', index: 'pay_status', width: 50, formatter: payStatusFormat},
            {label: '订单状态', name: 'orderStatus', index: 'order_status', width: 50, formatter: orderStatusFormat},
            {label: '代购状态', name: 'deliveryFlag', index: 'delivery_flag', width: 70, formatter: deliveryFlagFormat},
            {label: '代购时间', name: 'deliveryTime', index: 'delivery_time', width: 100},
            {label: '用户id', name: 'userId', index: 'user_id', width: 110,hidden:true},
            {label: '用户名', name: 'userName', index: 'user_name', width: 55},
            {label: '商品品名Id', name: 'descripitionId', index: 'descripition_id', width: 50,hidden:true},
          /*  {label: '商品品名id', name: 'templateId', index: 'templateId', width: 50,hidden:true},
            {label: '商品品名', name: 'templateTitle', index: 'templateTitle', width: 50,hidden:true},*/
            {label: '商品总价', name: 'itemsPrice', index: 'items_price', width: 80},
            {label: '总价', name: 'totalPrice', index: 'total_price', width: 80,hidden:true},
            {label: '实际付款', name: 'realityPay', index: 'reality_pay', width: 50,hidden:true},
            {label: '收货地址Id', name: 'deliveryAddressId', index: 'delivery_address_id', width: 110,hidden:true},
            {label: '收货地址', name: 'deliveryAddress', index: 'delivery_address', width: 120},
            {label: '收货人', name: 'deliveryName', index: 'delivery_name', width: 70},
            {label: '收货人手机', name: 'deliveryPhone', index: 'delivery_phone', width: 70},
            {label: '快递费', name: 'expressCost', index: 'express_cost', width: 80,hidden:true},
            {label: '更新时间', name: 'updateTime', index: 'update_time', width: 120,hidden:true},
            {label: '成交时间', name: 'dealTime', index: 'deal_time', width: 120,hidden:true},
            {label: '优惠券id', name: 'couponId', index: 'coupon_id', width: 120,hidden:true},
            {label: '优惠券标题', name: 'couponTitle', index: 'coupon_title', width: 120,hidden:true},
            {label: '优惠券减免价格', name: 'deductAmount', index: 'deduct_amount', width: 80,hidden:true},
            {label: '税费', name: 'tax', index: 'tax', width: 80,hidden:true},
            {label: '手续费', name: 'fee', index: 'fee', width: 80,hidden:true},
            {label: '交易号', name: 'payId', index: 'pay_id', width: 120,hidden:true},
            {label: '交易关闭时间', name: 'closeTime', index: 'close_time', width: 100}]
    });
    $.get('../tbcfexpresstemplate/queryAll',function (res) {
        vm.descripition=JSON.parse(res).list;
        // console.log(vm.descripition)
    })
});

let vm = new Vue({
    el: '#rrapp',
    data: {
        //商品详情
        itemVisible: false,
        //代购信息
        agentVisible: false,
        //订单详情
        orderVisible: false,
        //商品详情
        itemData: [],
        //订单详情
        ordersData: [],
        agentInfo: {
            orderId: "",
            //代购人
            userName: '',
            //快递单号
            pExpressNumber: '',
            //商品品名
            descripitionId:'',
            //实际付款
            realityPay: '',
            //原网站订单号
            pOrderId:'',
            //代购平台
            platformName: '' 
        },
        orderStatusOptions:[{
            value:'20',
            label:"已付款"
        },{
            value:'10',
            label:"未付款"
        },{
            value:'40',
            label:"已发货"
        },{
            value:'50',
            label:"交易成功"
        },{
            value:'60',
            label:"交易关闭"
        }],
        payStatusOptions:[{
            value:'20',
            label:"已支付"
        },{
            value:'10',
            label:"未支付"
        }],
        deliveryFlagOptions: [{
            value: '0',
            label: '未代购'
        },{
            value: '20',
            label: '已到达中国仓'
        },{
            value: '40', 
            label: '已到达非洲仓'
        }],
        pickerOptions: {
            shortcuts: [{
                text: '最近一周',
                onClick(picker) {
                    const end = new Date();
                    const start = new Date();
                    start.setTime(start.getTime() - 3600 * 1000 * 24 * 7);
                    picker.$emit('pick', [start, end]);
                }
            }, {
                text: '最近一个月',
                onClick(picker) {
                    const end = new Date();
                    const start = new Date();
                    start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
                    picker.$emit('pick', [start, end]);
                }
            }, {
                text: '最近三个月',
                onClick(picker) {
                    const end = new Date();
                    const start = new Date();
                    start.setTime(start.getTime() - 3600 * 1000 * 24 * 90);
                    picker.$emit('pick', [start, end]);
                }
            }]
        },
        formLabelWidth: '120px',
        value:'',
        showList: true,
        descripition: [],
        title: null,
        tbCfOrder: {},
        ruleValidate: {
            name: [
                {required: true, message: '名称不能为空', trigger: 'blur'}
            ]
        },
        orderNo:'',
        payStatus:'',
        orderStatus:'',
        deliveryFlag:''
    },
    methods: {
        perChange: function () {
            vm.reload();
        },
        query: function () {
            vm.reload();
        },
        add: function () {
            vm.showList = false;
            vm.title = "新增";
            vm.tbCfOrder = {};
        },
        //获取订单详情
        showOrders: function () {
            let orderId = getSelectedRow("#jqGrid");
            if (orderId == null) {
                return;
            }
            vm.orderVisible = true;
            vm.getOrderDetails(orderId);
        },
        //获取商品详情
        showItems: function () {
            let orderId = getSelectedRow("#jqGrid");
            if (orderId == null) {
                return;
            }
            vm.itemVisible = true;
            vm.getOrderItemList(orderId);
        },
        //获取代购信息
        showAgent: function () {
            let orderId = getSelectedRow("#jqGrid");
            if (orderId == null) {
                return;
            }
            let rowData=getSelectedRowData("#jqGrid");
            if(rowData.payStatus!="已支付") {
                layer.msg("订单尚未支付，不能添加代购信息！",{
                    time: 3000 //2秒关闭（如果不配置，默认是3秒）
                });
                return;
            }
            vm.agentVisible = true;
            vm.agentInfo.orderId = orderId;
            vm.getAgentInfo(orderId);
        },
        update: function (event) {
            let orderId = getSelectedRow("#jqGrid");
            if (orderId == null) {
                return;
            }
            vm.showList = false;
            vm.title = "修改";

            vm.getInfo(orderId);
        },
        saveOrUpdate: function (event) {
            let url = vm.tbCfOrder.orderId == null ? "../tbcforder/save" : "../tbcforder/update";
            Ajax.request({
                url: url,
                params: JSON.stringify(vm.tbCfOrder),
                type: "POST",
                contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
            });
        },
        del: function (event) {
            let orderIds = getSelectedRows("#jqGrid");
            if (orderIds == null) {
                return;
            }

            confirm('确定要删除选中的记录？', function () {
                Ajax.request({
                    url: "../tbcforder/delete",
                    params: JSON.stringify(orderIds),
                    type: "POST",
                    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
                    }
                });
            });
        },
        getInfo: function (orderId) {
            Ajax.request({
                url: "../tbcforder/info/" + orderId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfOrder = r.tbCfOrder;
                }
            });
        },
        /*获取订单中的商品*/
        getOrderItemList: function (orderId) {
            Ajax.request({
                url: "../tbcforder/item/" + orderId,
                async: true,
                successCallback: function (r) {
                    vm.itemData = r.list;
                }
            });
        },
        /*获取订单详情*/
        getOrderDetails: function (orderId) {
            Ajax.request({
                url: "../tbcforder/detail/" + orderId,
                async: true,
                successCallback: function (r1) {
                    vm.ordersData = r1.list;
                }
            });
        },
        /*获取订单的代购信息*/
        getAgentInfo: function (orderId) {
            Ajax.request({
                url: "../tbcforder/agent/" + orderId,
                async: true,
                type: "get",
                successCallback: function (r) {
                    console.log(r)
                    if (!!r.data) {
                        vm.agentInfo = r.data;
                    } else {
                        vm.agentInfo = {
							orderId:orderId,
                            //代购人
                            userName: '',
                            //商品品名
                            descripitionId: '',
                            //快递单号
                            pExpressNumber: '',
                            //实际付款
                            realityPay: '',
                            //原网站订单号
                            pOrderId: '',
                            //代购平台
                            platformName: ''
                        };
                    }
                }
            });
        },
        //新增或者修改代购信息
        saveOrUpdateAgentInfo: function () {
            console.log(vm.agentInfo.descripitionId);
            console.log(vm.agentInfo)
            if(vm.agentInfo.descripitionId){
                Ajax.request({
                    url: "../tbcforder/agent/",
                    params: JSON.stringify(vm.agentInfo),
                    type: "post",
                    // dataType: "json",
                    contentType: 'application/json',
                    successCallback: function (r) {
                        if(r.result=="1") {
                            vm.agentVisible = false;
                            layer.msg("保存成功", {
                                time: 2000 //2秒关闭（如果不配置，默认是3秒）
                            });
                        } else {
                            alert("保存失败");
                        }
                    }
                    // vm.agentInfo=r.data;
                });
            }else{
                alert("保存失败,请选择商品品名");
            }

        },
        reload: function (event) {
            vm.showList = true;
            let orderNo=vm.orderNo;
            let start=vm.value[0];
            let end=vm.value[1];
            let payStatus=vm.payStatus;
            let deliveryFlag=vm.deliveryFlag;
            let orderStatus=vm.orderStatus;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
            $("#jqGrid").jqGrid('setGridParam', {
                postData: {'name':orderNo,'start':start,'end':end,'payStatus':payStatus,'deliveryFlag':deliveryFlag,'orderStatus':orderStatus},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
        },
        reloadSearch: function () {
            vm.orderStatus='',
            vm.orderNo='',
            vm.value='',
            vm.payStatus='',
            vm.deliveryFlag='',
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
    }

});

