$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfitemcomment/list',
        colModel: [
			{label: 'id', name: 'id', index: 'id', key: true, hidden: true},
			{label: '评论人', name: 'userId', index: 'user_id', width: 80},
			{label: '订单ID', name: 'orderId', index: 'order_id', width: 80},
			{label: '商品ID', name: 'itemId', index: 'item_id', width: 80},
			{label: '商品评分', name: 'itemScore', index: 'item_score', width: 80},
			{label: '服务评分', name: 'serviceScore', index: 'service_score', width: 80},
			{label: '物流评分', name: 'logisticsScore', index: 'logistics_score', width: 80},
			{label: '价格评分', name: 'priceScore', index: 'price_score', width: 80},
			{label: '商品评论', name: 'itemReview', index: 'item_review', width: 80},
			{label: '点赞人数', name: 'likeNum', index: 'like_num', width: 80},
			{label: '状态', name: 'delFlag', index: 'del_flag', width: 80,formatter:statusFormat},
			{label: '创建时间', name: 'createTime', index: 'create_time', width: 80},
			{label: '回复时间', name: 'replyTime', index: 'reply_time', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfItemComment: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfItemComment = {};
		},
		update: function (event) {
            let id = getSelectedRow("#jqGrid");
			if (id == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(id);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfItemComment.id == null ? "../tbcfitemcomment/save" : "../tbcfitemcomment/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfItemComment),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let ids = getSelectedRows("#jqGrid");
			if (ids == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfitemcomment/delete",
                    params: JSON.stringify(ids),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(id){
            Ajax.request({
                url: "../tbcfitemcomment/info/"+id,
                async: true,
                successCallback: function (r) {
                    vm.tbCfItemComment = r.tbCfItemComment;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});