$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfgoodstype/list',
        colModel: [
			{label: 'goodstypeId', name: 'goodstypeId', index: 'goodstype_id', key: true, hidden: true},
			{label: '商品分类标题', name: 'goodstypeTitle', index: 'goodstype_title', width: 80},
			{label: '商品分类排序编号', name: 'goodstypeSort', index: 'goodstype_sort', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfGoodstype: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfGoodstype = {};
		},
		update: function (event) {
            let goodstypeId = getSelectedRow("#jqGrid");
			if (goodstypeId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(goodstypeId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfGoodstype.goodstypeId == null ? "../tbcfgoodstype/save" : "../tbcfgoodstype/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfGoodstype),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let goodstypeIds = getSelectedRows("#jqGrid");
			if (goodstypeIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfgoodstype/delete",
                    params: JSON.stringify(goodstypeIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(goodstypeId){
            Ajax.request({
                url: "../tbcfgoodstype/info/"+goodstypeId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfGoodstype = r.tbCfGoodstype;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});