$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfgoodstwotype/list',
        colModel: [
			{label: '商品二级分类Id', name: 'goodstwotypeId', index: 'goodstwotype_id', key: true, hidden: true},
			{label: '商品一级分类标题', name: 'goodstypeTitle', index: 'goodstype_title', width: 80},
			{label: '商品二级分类标题', name: 'goodstwotypeTitle', index: 'goodstwotype_title', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfGoodstwotype: {},
		Goodstype:null,
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfGoodstwotype = {};
		},
		update: function (event) {
            let goodstwotypeId = getSelectedRow("#jqGrid");
			if (goodstwotypeId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(goodstwotypeId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfGoodstwotype.goodstwotypeId == null ? "../tbcfgoodstwotype/save" : "../tbcfgoodstwotype/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfGoodstwotype),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let goodstwotypeIds = getSelectedRows("#jqGrid");
			if (goodstwotypeIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfgoodstwotype/delete",
                    params: JSON.stringify(goodstwotypeIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(goodstwotypeId){
            Ajax.request({
                url: "../tbcfgoodstwotype/info/"+goodstwotypeId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfGoodstwotype = r.tbCfGoodstwotype;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	},
	created(){
	var that = this
	$.get('../tbcfgoodstype/queryAll',function (res) {
		debugger
		// console.log(that,"this");
		that.Goodstype = res.list;
		// console.log(that.Goodstype);
	})
}
});