$(function () {
    $("#jqGrid").Grid({
        url: '../tbcffee/list',
        colModel: [
			{label: 'feeId', name: 'feeId', index: 'fee_id', key: true, hidden: true},
			//{label: '收费类型,1为百分比，目前只有一种收费方式', name: 'feeType', index: 'fee_type', width: 80},
			//{label: '是否生效标志', name: 'enableFlag', index: 'enable_flag', width: 80},
			{label: '收取费用百分比', name: 'feePercent', index: 'fee_percent', width: 80},
			{label: '设置美元转换', name: 'feeRate', index: 'fee_rate', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfFee: {},
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfFee = {};
		},
		update: function (event) {
            let feeId = getSelectedRow("#jqGrid");
			if (feeId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(feeId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfFee.feeId == null ? "../tbcffee/save" : "../tbcffee/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfFee),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let feeIds = getSelectedRows("#jqGrid");
			if (feeIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcffee/delete",
                    params: JSON.stringify(feeIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(feeId){
            Ajax.request({
                url: "../tbcffee/info/"+feeId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfFee = r.tbCfFee;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	}
});