$(function () {
    $("#jqGrid").Grid({
        url: '../tbcfdescripiton/list',
        colModel: [
			{label: 'descripitionId', name: 'descripitionId', index: 'descripition_id', key: true, hidden: true},
			{label: '商品品名', name: 'descripitionName', index: 'descripition_name', width: 80},
			{label: '海关编码', name: 'descripitionCode', index: 'descripition_code', width: 80},
			{label: '商品一级分类标题', name: 'goodtype', index: 'goodtype', width: 80},
			{label: '商品二级分类标题', name: 'title', index: 'title', width: 80}]
    });
});

let vm = new Vue({
	el: '#rrapp',
	data: {
        showList: true,
        title: null,
		tbCfDescripiton: {},
		Goodstype2:null,
		Goodstype:null,
		GoodstypeTwo:null,
		ruleValidate: {
			name: [
				{required: true, message: '名称不能为空', trigger: 'blur'}
			]
		},
		q: {
		    name: ''
		}
	},
	methods: {
		changeGoodstype(){
			let url = `/africa_shop/tbcfdescripiton/queryByItemType?typeId=${this.tbCfDescripiton.goodstypeId}`
			 console.log('url',url)
			 let that = this;
			Ajax.request({
				url: url,
				type: "get",
				contentType: "application/json",
				successCallback: function (r) {
					console.log('res',r)
					if(r.code===0){
						that.Goodstype2 = r.list
						console.log(that.Goodstype2)
					}
				}
			});
		},
		query: function () {
			vm.reload();
		},
		add: function () {
			vm.showList = false;
			vm.title = "新增";
			vm.tbCfDescripiton = {};
		},
		update: function (event) {
            let descripitionId = getSelectedRow("#jqGrid");
			if (descripitionId == null) {
				return;
			}
			vm.showList = false;
            vm.title = "修改";

            vm.getInfo(descripitionId);
		},
		saveOrUpdate: function (event) {
            let url = vm.tbCfDescripiton.descripitionId == null ? "../tbcfdescripiton/save" : "../tbcfdescripiton/update";
            Ajax.request({
			    url: url,
                params: JSON.stringify(vm.tbCfDescripiton),
                type: "POST",
			    contentType: "application/json",
                successCallback: function (r) {
                    alert('操作成功', function (index) {
                        vm.reload();
                    });
                }
			});
		},
		del: function (event) {
            let descripitionIds = getSelectedRows("#jqGrid");
			if (descripitionIds == null){
				return;
			}

			confirm('确定要删除选中的记录？', function () {
                Ajax.request({
				    url: "../tbcfdescripiton/delete",
                    params: JSON.stringify(descripitionIds),
                    type: "POST",
				    contentType: "application/json",
                    successCallback: function () {
                        alert('操作成功', function (index) {
                            vm.reload();
                        });
					}
				});
			});
		},
		getInfo: function(descripitionId){
            Ajax.request({
                url: "../tbcfdescripiton/info/"+descripitionId,
                async: true,
                successCallback: function (r) {
                    vm.tbCfDescripiton = r.tbCfDescripiton;
                }
            });
		},
		reload: function (event) {
			vm.showList = true;
            let page = $("#jqGrid").jqGrid('getGridParam', 'page');
			$("#jqGrid").jqGrid('setGridParam', {
                postData: {'name': vm.q.name},
                page: page
            }).trigger("reloadGrid");
            vm.handleReset('formValidate');
		},
        reloadSearch: function() {
            vm.q = {
                name: ''
            };
            vm.reload();
        },
        handleSubmit: function (name) {
            handleSubmitValidate(this, name, function () {
                vm.saveOrUpdate()
            });
        },
        handleReset: function (name) {
            handleResetForm(this, name);
        }
	},
	created() {
		var that = this
		$.get('../tbcfgoodstype/queryAll', function (res) {
			// console.log(that,"this");
			that.Goodstype = res.list;
			// console.log(that.Goodstype);
		});
		$.get('../tbcfgoodstwotype/queryAll', function (res) {
			// console.log(that,"this");
			that.GoodstypeTwo = res.list;

			// console.log(res);
		});
	}
});