package com.diaoyun.zion.master.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.constant.YunpianConstant;
import com.yunpian.sdk.model.SmsBatchSend;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.junit.Test;

/**
 * 短信接口类
 *
 * @author lyl
 * <p>
 * 2018年4月18日
 */
public class SMSUtil {

    //查账户信息的http地址
    private static String URI_GET_USER_INFO = "https://sms.yunpian.com/v2/user/get.json";

    //模板发送接口的http地址
    private static String URI_TPL_SEND_SMS = "https://sms.yunpian.com/v2/sms/tpl_single_send.json";
    private static String URI_SINGLE_SEND_SMS = "https://sms.yunpian.com/v2/sms/single_send.json";
    //编码格式。发送编码格式统一用UTF-8
    private static String ENCODING = "UTF-8";
    private static String API_KEY = "cb20310db0e7dcc76a827afbd2ba548f";

    /**
     * 查询用户信息
     *
     * @param apikey
     * @return
     * @throws IOException
     * @throws URISyntaxException
     */
    public static String getUserInfo(String apikey) throws IOException, URISyntaxException {
        Map<String, String> params = new HashMap<String, String>();
        params.put("apikey", apikey);
        return post(URI_GET_USER_INFO, params);
    }

    /**
     * 提交响应
     *
     * @param url
     * @param paramsMap
     * @return
     */
    public static String post(String url, Map<String, String> paramsMap) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpPost method = new HttpPost(url);
            if (paramsMap != null) {
                List<NameValuePair> paramList = new ArrayList<NameValuePair>();
                for (Map.Entry<String, String> param : paramsMap.entrySet()) {
                    NameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
                    paramList.add(pair);
                }
                method.setEntity(new UrlEncodedFormEntity(paramList, ENCODING));
            }
            response = client.execute(method);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseText = EntityUtils.toString(entity, ENCODING);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                response.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }


    /**
     * 发送验证码
     *
     * @return
     * @throws IOException
     */
    public static String yzCode(String phone) throws IOException {

        if (phone.equals(null)) {
            return "error";
        }
        //编码格式。发送编码格式统一用UTF-8
        String ENCODING = "UTF-8";
        long tpl_id = 3253208;//模板ID
        String code = RandomStringUtils.randomNumeric(6);// 生成6位随机验证码
        String tpl_value = URLEncoder.encode("#code#", ENCODING) + "="
                + URLEncoder.encode(code, ENCODING);
        System.out.println(tpl_value);
        System.out.println(SMSUtil.tplSendSms(API_KEY, tpl_id, tpl_value, phone));
        return code;
    }

    /**
     * 通过模板发送短信
     *
     * @param apikey
     * @param tpl_id
     * @param tpl_value
     * @param mobile
     * @return
     * @throws IOException
     */
    public static String tplSendSms(String apikey, long tpl_id, String tpl_value, String mobile) throws IOException {
        Map<String, String> params = new HashMap<String, String>();
        params.put("apikey", apikey);
        params.put("tpl_id", String.valueOf(tpl_id));
        params.put("tpl_value", tpl_value);
        params.put("mobile", mobile);
        return post(URI_TPL_SEND_SMS, params);
    }


    /**
     * 通过模板群发（新版）
     *
     * @param phone
     * @param tplId
     * @param tplVal
     */
    public static void sendMessageByTpl(String phone, String tplId, String tplVal) {
        YunpianClient clnt = new YunpianClient(API_KEY).init();
        Map<String, String> param = clnt.newParam(5);
        param.put(YunpianConstant.MOBILE, phone);
        param.put(YunpianConstant.TPL_ID, tplId);
        String code = RandomStringUtils.randomNumeric(6);
        param.put(YunpianConstant.TPL_VALUE, tplVal);
        com.yunpian.sdk.model.Result<SmsBatchSend> r = clnt.sms().tpl_batch_send(param);
        System.out.println(r);
    }

    /**
     * 群发短信（新版）
     *
     * @param phone
     * @param text
     */
    public static void sendMessageByText(String phone, String text) {
        YunpianClient clnt = new YunpianClient(API_KEY).init();
        Map<String, String> param = clnt.newParam(5);
        param.put(YunpianConstant.MOBILE, phone);
        String code = RandomStringUtils.randomNumeric(6);
        param.put(YunpianConstant.TEXT, text);
        com.yunpian.sdk.model.Result<SmsBatchSend> result = clnt.sms().batch_send(param);
        System.out.println(result);
    }


    /**
     * 发送物流短信
     *
     * @param phone
     */
    public static void sendLogisticsMessage(String phone) {
        String message = "【Afrishop】Thank you for shopping with Afrishop! Your parcel has arrived in Zambia.";
        sendMessageByText(phone, message);
    }

    public static void main(String[] args) throws IOException {
        String phone = "13751400455,18607444177";
        SMSUtil.sendLogisticsMessage(phone);


    }
}

