package com.diaoyun.zion.master.thread;

import com.diaoyun.zion.master.bo.TencentTranslateParam;
import com.diaoyun.zion.master.config.DomainProperties;
import com.diaoyun.zion.master.enums.TranslateLanguageEnum;
import com.diaoyun.zion.master.util.IdUtil;
import com.diaoyun.zion.master.util.SpringContextUtil;
import org.apache.http.Consts;

import java.util.Map;

/**
 * 腾讯翻译类
 * https://api.ai.qq.com/fcgi-bin/nlp/nlp_texttranslate
 */
public class TranslateCallable extends AbstractTencentCallable<TencentTranslateParam> {

    //private static Logger logger = LoggerFactory.getLogger(TranslateCallable.class);
    private static DomainProperties domainProperties = (DomainProperties) SpringContextUtil.getBean("domainProperties");

    public TranslateCallable(TencentTranslateParam param) {
        this.app_id = Integer.valueOf(domainProperties.getProperty("tencent.translate.app_id"));
        this.app_url = domainProperties.getProperty("tencent.translate.app_url");
        this.param = param;
        this.charset = Consts.UTF_8.name();
    }

    // TODO 泛型
    @Override
    public Map<String, Object> call() throws Exception {
        //填充参数
        fillParam(param);
        Map<String, Object> resultMap = super.call();
        return resultMap;
    }

    /**
     * 填充翻译时参数
     *
     * @param param
     */
    @Override
    void fillParam(TencentTranslateParam param) {
        if (param.getApp_id() == null) {
            param.setApp_id(this.app_id);
        }
        if (param.getNonce_str() == null) {
            String randomLetters = IdUtil.createIdbyUUID();
            param.setNonce_str(randomLetters);
        }
        if (param.getTime_stamp() == null) {
            long currentTime = System.currentTimeMillis() / 1000;
            param.setTime_stamp(currentTime);
        }
        if (param.getSource() == null) {
            param.setSource(TranslateLanguageEnum.ZH.getValue());
        }
        if (param.getTarget() == null) {
            param.setTarget(TranslateLanguageEnum.EN.getValue());
        }
    }


}
