package com.diaoyun.zion.master.enums;

public enum ResultCodeEnum {
    SUCCESS(1,"success"),
    ORDER_PAY_ERROR(9008,"payment failure"),
    REFUND_PAY_ERROR(9009,"payment failure"),
    QUERY_ERROR(9005,"query fails"),
    ERROR(9999,"unknown error"),
    APPLICATION_ERROR(9000,"application error"),
    VALIDATE_ERROR(9001,"validate error"),
    SERVICE_ERROR(9002,"service error"),
    CACHE_ERROR(9003,"cache error"),
    DAO_ERROR(9004,"dao error"),
    NEED_LOGIN(10,"need login"),
    ILLEGAL_ARGUMENT(2,"illegal argument");



    //成员变量（常量）
    private final int code;
    private final String desc;

    //构造方法
    ResultCodeEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }
    //普通函数
    public int getCode(){
        return code;
    }
    public String getDesc(){
        return desc;
    }

}
