package com.diaoyun.zion.chinafrica.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户表实体
 * 表名 tb_cf_user_info
 *
 * @author G
 * @date 2019-08-14 09:11:47
 */
@ApiModel
public class TbCfUserInfoVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 用户id
     */
    @ApiModelProperty(value="用户id",name="userId")
    private String userId;
    /**
     * 用户编号
     */
    @ApiModelProperty(value="用户编号（用于展示而已）",name="userNo")
    private String userNo;
    /**
     * 用户类型（1邮箱、2facebook、3手机）
     */
    @ApiModelProperty(value="用户类型（1邮箱、2facebook、3手机）",name="userType")
    private Integer userType;
    /**
     * 账号
     */
    @ApiModelProperty(value="账号",name="account",required=true)
    private String account;
    /**
     * 用户头像地址
     */
    @ApiModelProperty(value="用户头像地址")
    private String avatar;
    /**
     * 用户名
     */
    @ApiModelProperty(value="用户名",required=true)
    private String nick;
    /**
     * 电话号码
     */
    @ApiModelProperty(value="电话号码")
    private String phone;
    /**
     * 是否绑定手机
     */
    @ApiModelProperty(value="是否绑定手机")
    private Integer phoneFlag;
    /**
     * 密码
     */
    @ApiModelProperty(value="密码",required=true)
    private String password;
    /**
     * 上一次登录时间
     */
    @ApiModelProperty(value="上一次登录时间")
    private Date lastLoginTime;
    /**
     * 上一次登录IP
     */
    @ApiModelProperty(value="上一次登录IP")
    private String lastLoginIp;
    /**
     * 登录次数
     */
    @ApiModelProperty(value="登录次数")
    private Integer loginCount;
    /**
     * 邮箱
     */
    @ApiModelProperty(value="邮箱",required=true)
    private String email;
    /**
     * 邮箱验证 0未验证，1已验证
     */
    @ApiModelProperty(value="邮箱验证 0未验证，1已验证")
    private Integer emailFlag;
    /**
     * facebook账号
     */
    @ApiModelProperty(value="facebook账号")
    private String facebook;
    /**
     * 创建时间
     */
    @ApiModelProperty(value="创建时间")
    private Date createTime;
    /**
     * 性别
     */
    @ApiModelProperty(value="性别")
    private Integer sex;
    /**
     * 默认地址id
     */
    @ApiModelProperty(value="默认地址id")
    private String defaultAddressId;
    /**
     * 发出邀请的用户
     */
    @ApiModelProperty(value="发出邀请的用户")
    private String invitedUserId;
    /**
     * 总共邀请用户的数量
     */
    @ApiModelProperty(value="总共邀请用户的数量")
    private Integer invitedCount;
    /**
     * 是否有效
     */
    @ApiModelProperty(value="是否有效")
    private Integer enableFlag;

    /**
     * 验证码
     */
    @ApiModelProperty(value="验证码",required=true)
    private Integer captcha;

    /**
     * token
     */
    @ApiModelProperty(value="用户token")
    private String token;

    /**
     * 设置：用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }


    /**
     * 获取：用户id
     */
    public String getUserId() {
        return userId;
    }
    /**
     * 设置：用户编号
     */
    public void setUserNo(String userNo) {
        this.userNo = userNo;
    }

    /**
     * 获取：用户编号
     */
    public String getUserNo() {
        return userNo;
    }
    /**
     * 设置：用户类型（1邮箱、2facebook、3手机）
     */
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    /**
     * 获取：用户类型（1邮箱、2facebook、3手机）
     */
    public Integer getUserType() {
        return userType;
    }
    /**
     * 设置：账号
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * 获取：账号
     */
    public String getAccount() {
        return account;
    }
    /**
     * 设置：用户头像地址
     */
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    /**
     * 获取：用户头像地址
     */
    public String getAvatar() {
        return avatar;
    }
    /**
     * 设置：用户名
     */
    public void setNick(String nick) {
        this.nick = nick;
    }

    /**
     * 获取：用户名
     */
    public String getNick() {
        return nick;
    }
    /**
     * 设置：电话号码
     */
    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 获取：电话号码
     */
    public String getPhone() {
        return phone;
    }
    /**
     * 设置：是否绑定手机
     */
    public void setPhoneFlag(Integer phoneFlag) {
        this.phoneFlag = phoneFlag;
    }

    /**
     * 获取：是否绑定手机
     */
    public Integer getPhoneFlag() {
        return phoneFlag;
    }
    /**
     * 设置：密码
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * 获取：密码
     */
    public String getPassword() {
        return password;
    }
    /**
     * 设置：上一次登录时间
     */
    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    /**
     * 获取：上一次登录时间
     */
    public Date getLastLoginTime() {
        return lastLoginTime;
    }
    /**
     * 设置：上一次登录IP
     */
    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    /**
     * 获取：上一次登录IP
     */
    public String getLastLoginIp() {
        return lastLoginIp;
    }
    /**
     * 设置：登录次数
     */
    public void setLoginCount(Integer loginCount) {
        this.loginCount = loginCount;
    }

    /**
     * 获取：登录次数
     */
    public Integer getLoginCount() {
        return loginCount;
    }
    /**
     * 设置：邮箱
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * 获取：邮箱
     */
    public String getEmail() {
        return email;
    }
    /**
     * 设置：facebook账号
     */
    public void setFacebook(String facebook) {
        this.facebook = facebook;
    }

    /**
     * 获取：facebook账号
     */
    public String getFacebook() {
        return facebook;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：性别
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }

    /**
     * 获取：性别
     */
    public Integer getSex() {
        return sex;
    }
    /**
     * 设置：默认地址id
     */
    public void setDefaultAddressId(String defaultAddressId) {
        this.defaultAddressId = defaultAddressId;
    }

    /**
     * 获取：默认地址id
     */
    public String getDefaultAddressId() {
        return defaultAddressId;
    }
    /**
     * 设置：发出邀请的用户
     */
    public void setInvitedUserId(String invitedUserId) {
        this.invitedUserId = invitedUserId;
    }

    /**
     * 获取：发出邀请的用户
     */
    public String getInvitedUserId() {
        return invitedUserId;
    }
    /**
     * 设置：总共邀请数量
     */
    public void setInvitedCount(Integer invitedCount) {
        this.invitedCount = invitedCount;
    }

    /**
     * 获取：总共邀请数量
     */
    public Integer getInvitedCount() {
        return invitedCount;
    }
    /**
     * 设置：是否有效
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    /**
     * 获取：是否有效
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }

    public Integer getCaptcha() {
        return captcha;
    }

    public void setCaptcha(Integer captcha) {
        this.captcha = captcha;
    }

    public Integer getEmailFlag() {
        return emailFlag;
    }

    public void setEmailFlag(Integer emailFlag) {
        this.emailFlag = emailFlag;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}
