package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfFinanceDao;
import com.diaoyun.zion.chinafrica.entity.TbCfFinanceEntity;
import com.diaoyun.zion.chinafrica.service.TbCfFinanceService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 财务明细Service实现类
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Service("tbCfFinanceService")
public class TbCfFinanceServiceImpl implements TbCfFinanceService {
    @Autowired
    private TbCfFinanceDao tbCfFinanceDao;

    @Override
    public TbCfFinanceEntity queryObject(String finaceId) {
        return tbCfFinanceDao.queryObject(finaceId);
    }

    @Override
    public List<TbCfFinanceEntity> queryList(Map<String, Object> map) {
        return tbCfFinanceDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfFinanceDao.queryTotal(map);
    }

    @Override
    public int save(TbCfFinanceEntity tbCfFinance) {
        tbCfFinance.setFinaceId(IdUtil.createIdbyUUID());
        return tbCfFinanceDao.save(tbCfFinance);
    }

    @Override
    public int update(TbCfFinanceEntity tbCfFinance) {
        return tbCfFinanceDao.update(tbCfFinance);
    }

    @Override
    public int delete(String finaceId) {
        return tbCfFinanceDao.delete(finaceId);
    }

    @Override
    public int deleteBatch(String[] finaceIds) {
        return tbCfFinanceDao.deleteBatch(finaceIds);
    }
}
