package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfFeedbackRecordDao;
import com.diaoyun.zion.chinafrica.entity.TbCfFeedbackRecordEntity;
import com.diaoyun.zion.chinafrica.service.TbCfFeedbackRecordService;
import com.diaoyun.zion.chinafrica.vo.TbCfFeedbackRecordListVo;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.StateConstant;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import com.diaoyun.zion.master.security.JwtTokenProvider;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 用户反馈记录表Service实现类
 *
 * @author lipengjun
 * @date 2019-09-21 15:15:23
 */
@Service("tbCfFeedbackRecordService")
public class TbCfFeedbackRecordServiceImpl implements TbCfFeedbackRecordService {
    @Autowired
    private TbCfFeedbackRecordDao tbCfFeedbackRecordDao;
    @Autowired
    @Qualifier("redisTokenManager")
    private TokenManager tokenManager;
    @Autowired
    private JwtTokenProvider jwtTokenProvider;
    @Autowired
    private HttpServletRequest request; //自动注入request

    @Override
    public TbCfFeedbackRecordEntity queryObject(String recordId) {
        return tbCfFeedbackRecordDao.queryObject(recordId);
    }

    @Override
    public List<TbCfFeedbackRecordEntity> queryList(Map<String, Object> map) {
        return tbCfFeedbackRecordDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfFeedbackRecordDao.queryTotal(map);
    }

    @Override
    public int save(TbCfFeedbackRecordEntity tbCfFeedbackRecord) {
        tbCfFeedbackRecord.setRecordId(IdUtil.createIdbyUUID());
        return tbCfFeedbackRecordDao.save(tbCfFeedbackRecord);
    }

    @Override
    public int update(TbCfFeedbackRecordEntity tbCfFeedbackRecord) {
        return tbCfFeedbackRecordDao.update(tbCfFeedbackRecord);
    }

    @Override
    public int delete(String recordId) {
        return tbCfFeedbackRecordDao.delete(recordId);
    }

    @Override
    public int deleteBatch(String[] recordIds) {
        return tbCfFeedbackRecordDao.deleteBatch(recordIds);
    }

    @Override
    public Result saveFeedback(TbCfFeedbackRecordEntity tbCfFeedbackRecordEntity) {
        Result result = new Result();
        //获取用户
        String token = jwtTokenProvider.resolveToken(request);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        tbCfFeedbackRecordEntity.setRecordId(IdUtil.createIdbyUUID());
        tbCfFeedbackRecordEntity.setUserId(tbCfUserInfoVo.getUserId());
        tbCfFeedbackRecordEntity.setCreateTime(new Date());
        int res = tbCfFeedbackRecordDao.save(tbCfFeedbackRecordEntity);
        if (res > 0) {
            result.setMessage(ResultCodeEnum.SUCCESS.getDesc());
        } else {
            result.setCode(ResultCodeEnum.DAO_ERROR.getCode()).setMessage(ResultCodeEnum.DAO_ERROR.getDesc());
        }
        return result;
    }

    @Override
    public Result saveFeedbackList(TbCfFeedbackRecordListVo tbCfFeedbackRecordListVo) {
        Result result = new Result();
        //获取用户
        String token = jwtTokenProvider.resolveToken(request);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        if (!tbCfFeedbackRecordListVo.getFeedbackList().isEmpty()) {
            List<TbCfFeedbackRecordEntity> feedbackList = tbCfFeedbackRecordListVo.getFeedbackList();
            for (TbCfFeedbackRecordEntity feedback : feedbackList) {
                feedback.setRecordId(IdUtil.createIdbyUUID());
                feedback.setUserId(tbCfUserInfoVo.getUserId());
                feedback.setCreateTime(new Date());
            }
            int res = tbCfFeedbackRecordDao.saveBatch(feedbackList);
            result.setMessage("Successfully save " + res + " feedback");
        } else {
            result.setCode(ResultCodeEnum.ERROR.getCode()).setMessage("no feedback");
        }
        return result;
    }
}
