package com.diaoyun.zion.chinafrica.service.impl;


import com.diaoyun.zion.chinafrica.dao.TbCfCouponIssueDao;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponIssueEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.service.TbCfCouponIssueService;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 优惠券发放Service实现类
 *
 * @author lipengjun
 * @date 2019-10-21 12:11:53
 */
@Service("tbCfCouponIssueService")
public class TbCfCouponIssueServiceImpl implements TbCfCouponIssueService {
    @Autowired
    private TbCfCouponIssueDao tbCfCouponIssueDao;

    @Override
    public TbCfCouponIssueEntity queryObject(String couponIssueId) {
        return tbCfCouponIssueDao.queryObject(couponIssueId);
    }

    @Override
    public List<TbCfCouponIssueEntity> queryList(Map<String, Object> map) {
        return tbCfCouponIssueDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfCouponIssueDao.queryTotal(map);
    }

    @Override
    public int save(TbCfCouponIssueEntity tbCfCouponIssue) {
        tbCfCouponIssue.setCouponIssueId(IdUtil.createIdbyUUID());
        return tbCfCouponIssueDao.save(tbCfCouponIssue);
    }

    @Override
    public int update(TbCfCouponIssueEntity tbCfCouponIssue) {
        return tbCfCouponIssueDao.update(tbCfCouponIssue);
    }

    @Override
    public int delete(String couponIssueId) {
        return tbCfCouponIssueDao.delete(couponIssueId);
    }

    @Override
    public int deleteBatch(String[] couponIssueIds) {
        return tbCfCouponIssueDao.deleteBatch(couponIssueIds);
    }

    @Override
    public List<TbCfUserInfoEntity> queryByUserStatus(Integer status) {
        return tbCfCouponIssueDao.queryByUserStatus(status);
    }

    @Override
    public int queryByStatus(String couponIssueId) {
        return tbCfCouponIssueDao.queryByStatus(couponIssueId);
    }


}
