package com.diaoyun.zion.chinafrica.service.impl;

import com.diaoyun.zion.chinafrica.dao.TbCfAddressDao;
import com.diaoyun.zion.chinafrica.dao.TbCfCartRecordRDao;
import com.diaoyun.zion.chinafrica.dao.TbCfUserInfoDao;
import com.diaoyun.zion.chinafrica.entity.TbCfAddressEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.service.TbCfAddressService;
import com.diaoyun.zion.chinafrica.vo.TbCfAddressVo;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.base.StateConstant;
import com.diaoyun.zion.master.common.TokenManager;
import com.diaoyun.zion.master.security.JwtTokenProvider;
import com.diaoyun.zion.master.util.IdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Service实现类
 *
 * @author G
 * @date 2019-08-16 15:51:16
 */
@Service("tbCfAddressService")
public class TbCfAddressServiceImpl implements TbCfAddressService {
    @Autowired
    private TbCfAddressDao tbCfAddressDao;
    @Autowired
    private TbCfUserInfoDao tbCfUserInfoDao;
    @Resource(name="redisTokenManager")
    private TokenManager tokenManager;
    @Autowired
    private JwtTokenProvider jwtTokenProvider;
    @Autowired
    private HttpServletRequest request; //自动注入request

    @Override
    public TbCfAddressEntity queryObject(String addressId) {
        return tbCfAddressDao.queryObject(addressId);
    }

    @Override
    public List<TbCfAddressEntity> queryList(Map<String, Object> map) {
        return tbCfAddressDao.queryList(map);
    }

    @Override
    public int queryTotal(Map<String, Object> map) {
        return tbCfAddressDao.queryTotal(map);
    }

    @Override
    public int save(TbCfAddressEntity tbCfAddress) {
        tbCfAddress.setAddressId(IdUtil.createIdbyUUID());
        return tbCfAddressDao.save(tbCfAddress);
    }

    @Override
    public int update(TbCfAddressEntity tbCfAddress) {
        return tbCfAddressDao.update(tbCfAddress);
    }

    @Override
    public int delete(String addressId) {
        return tbCfAddressDao.delete(addressId);
    }

    @Override
    public int deleteBatch(String[] addressIds) {
        return tbCfAddressDao.deleteBatch(addressIds);
    }

    @Override
    public TbCfAddressVo saveAddress(TbCfAddressVo tbCfAddressVo) {
        String token = jwtTokenProvider.resolveToken(request);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        String userId=tbCfUserInfoVo.getUserId();
        tbCfAddressVo.setUserId(userId);
        /**
         * 新增地址必要信息
         */
        fillNewAddressInfo(tbCfAddressVo);
        TbCfAddressEntity tbCfAddressEntity = new TbCfAddressEntity();
        BeanUtils.copyProperties(tbCfAddressVo,tbCfAddressEntity);
        tbCfAddressDao.save(tbCfAddressEntity);
        return tbCfAddressVo;
    }

    @Override
    public TbCfAddressVo updateAddress(TbCfAddressVo tbCfAddressVo) {
        String token = jwtTokenProvider.resolveToken(request);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        String userId=tbCfUserInfoVo.getUserId();
        tbCfAddressVo.setUserId(userId);
        /**
         * 修改地址必要信息
         */
        fillUpdateAddressInfo(tbCfAddressVo);
        TbCfAddressEntity tbCfAddressEntity = new TbCfAddressEntity();
        BeanUtils.copyProperties(tbCfAddressVo,tbCfAddressEntity);
        this.update(tbCfAddressEntity);
        return tbCfAddressVo;
    }

    @Override
    public List<TbCfAddressVo> getUserInfoList() {
        String token = jwtTokenProvider.resolveToken(request);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        String userId=tbCfUserInfoVo.getUserId();
        List<TbCfAddressEntity> tbCfAddressList=tbCfAddressDao.queryListByUserId(userId);
        List<TbCfAddressVo> tbCfAddressVoList=new ArrayList<>();
        if(tbCfAddressList!=null) {
            for(TbCfAddressEntity tbCfAddress:tbCfAddressList) {
                TbCfAddressVo tbCfAddressVo = new TbCfAddressVo();
                BeanUtils.copyProperties(tbCfAddress,tbCfAddressVo);
                tbCfAddressVoList.add(tbCfAddressVo);
            }
        }
        return tbCfAddressVoList;
    }

    @Override
    public int configDefaultAddress(String addressId) {
        String token = jwtTokenProvider.resolveToken(request);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        String userId=tbCfUserInfoVo.getUserId();
        //更新用户默认地址
        TbCfUserInfoEntity user = new TbCfUserInfoEntity();
        user.setUserId(userId);
        user.setDefaultAddressId(addressId);
        int userCount=tbCfUserInfoDao.update(user);
        //更新缓存
        tbCfUserInfoVo.setDefaultAddressId(addressId);
        tokenManager.addToken(token, tbCfUserInfoVo);
        //重置用户地址
        tbCfAddressDao.resetDefaulFlag(userId);//int resetCount=
        //更新地址默认标志
        TbCfAddressEntity tbCfAddressEntity = new TbCfAddressEntity();
        tbCfAddressEntity.setAddressId(addressId);
        tbCfAddressEntity.setDefaultFlag(StateConstant.VALID);
        int addressCount=tbCfAddressDao.update(tbCfAddressEntity);
        return userCount*addressCount;
    }

    @Override
    public Result getDefaultAddress() {
        String token = jwtTokenProvider.resolveToken(request);
        TbCfUserInfoVo tbCfUserInfoVo = tokenManager.validate(token);
        String userId=tbCfUserInfoVo.getUserId();
        TbCfAddressEntity tbCfAddressEntity=tbCfAddressDao.getDefaultAddress(userId);
        TbCfAddressVo tbCfAddressVo = new TbCfAddressVo();
        if(tbCfAddressEntity!=null) {
            BeanUtils.copyProperties(tbCfAddressEntity,tbCfAddressVo);
        } else {
            tbCfAddressVo=null;
        }
        return new Result<>(tbCfAddressVo);
    }

    @Override
    public Result getAddressDetailById(String addressId) {
        TbCfAddressEntity tbCfAddressEntity=tbCfAddressDao.queryObject(addressId);
        TbCfAddressVo tbCfAddressVo = new TbCfAddressVo();
        if(tbCfAddressEntity!=null) {
            BeanUtils.copyProperties(tbCfAddressEntity,tbCfAddressVo);
        }
        return new Result<>(tbCfAddressVo);
    }

    /**
     * 新增地址必要信息
     */
    private void fillNewAddressInfo(TbCfAddressVo tbCfAddressVo) {
        tbCfAddressVo.setAddressId(IdUtil.createIdbyUUID());
        tbCfAddressVo.setCreateTime(new Date());
        tbCfAddressVo.setUpdateTime(new Date());
    }
    /**
     * 修改地址必要信息
     */
    private void fillUpdateAddressInfo(TbCfAddressVo tbCfAddressVo) {
        tbCfAddressVo.setUpdateTime(new Date());
    }
}
