package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfUserInfoEntity;
import com.diaoyun.zion.chinafrica.vo.TbCfUserInfoVo;
import com.diaoyun.zion.master.base.Result;
import freemarker.template.TemplateException;
import org.apache.commons.mail.EmailException;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * 用户表Service接口
 *
 * @author G
 * @date 2019-08-14 09:11:47
 */
public interface TbCfUserInfoService {

    /**
     * 根据主键查询实体
     *
     * @param userId 主键
     * @return 实体
     */
    TbCfUserInfoEntity queryObject(String userId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfUserInfoEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfUserInfo 实体
     * @return 保存条数
     */
    int save(TbCfUserInfoEntity tbCfUserInfo);

    /**
     * 根据主键更新实体
     *
     * @param tbCfUserInfo 实体
     * @return 更新条数
     */
    int update(TbCfUserInfoEntity tbCfUserInfo);

    /**
     * 根据主键删除
     *
     * @param userId
     * @return 删除条数
     */
    int delete(String userId);

    /**
     * 根据主键批量删除
     *
     * @param userIds
     * @return 删除条数
     */
    int deleteBatch(String[] userIds);

    String getUserPhoneCode(String phone) throws IOException;
    /**
     * 发送注册验证码
     * @param email
     * @return
     */
    Integer sendRegisterIdentifyCode(String email,String nick) throws EmailException, TemplateException, IOException;

    /**
     * 注册和登录
     * @param tbCfUserInfoVo
     * @return
     */
    Result registerAndLogin(TbCfUserInfoVo tbCfUserInfoVo) throws ParseException;

    /**
     *通过手机注册
     * @param tbCfUserInfoVo
     * @return
     */
    Result<TbCfUserInfoVo> registerByPhone(TbCfUserInfoVo tbCfUserInfoVo,String code) throws  ParseException;
    /**
     * 用户登录
     * @param ipAddr
     * @param account
     * @param password
     * @return
     */
    Result login(String ipAddr, String account, String password);

    /**
     * 通过手机号登录
     * @param ipAddr
     * @param phone
     * @param code
     * @return
     */
    Result loginByPhone(String ipAddr,String phone,String code);
    /**
     * 根据账号 手机、email、昵称 userId 查找
     * @param account
     * @return
     */
    TbCfUserInfoEntity findByAccount(String account);
    TbCfUserInfoEntity findAccount(String account);
    /**
     * 更改用户密码
     * @param newPassword
     * @param oldPassword
     * @return
     */
    Result updatePassWord(String newPassword, String oldPassword);

    /**
     * 退出登录
     * @return
     */
    Result logout();

    /**
     * 修改用户信息
     * @param tbCfUserInfoVo
     * @return
     */
    int updateUserInfo(TbCfUserInfoVo tbCfUserInfoVo);

    /**
     * 第三方账号登录
     * @param ip
     * @param amount
     * @param nick
     * @param userType
     * @return
     */
    Result loginByThirdParty(String ip,String amount,String nick,String userType) throws UnsupportedEncodingException;

    /**
     * 使用token登录
     * @param ipAddr
     * @return
     */
    Result loginByToken(String ipAddr);

    /**
     * 重置密码
     * @param account
     * @param newPassword
     * @param captcha
     * @return
     */
    Result resetPassWord(String account,String newPassword, Integer captcha);

    /**
     * 获取用户信息
     * @return
     */
    Result<TbCfUserInfoVo> getUserInfo();


    boolean checkUserByNick(String name);

    Result queryUserByUserId(String userId);
    List<TbCfUserInfoEntity> selectUserByPhone();

    List<String> findEmails();

    String sendRegister(String email) throws EmailException, TemplateException, IOException;
}
