package com.diaoyun.zion.chinafrica.service;


import com.diaoyun.zion.chinafrica.entity.CouponItem;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponIssueEntity;
import com.diaoyun.zion.chinafrica.entity.TbCfToicouponEntity;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * Service接口
 *
 * @author lipengjun
 * @date 2019-11-20 19:37:20
 */
public interface TbCfToiCouponService {

    Result<CouponItem> queryCouponByUserId(String userId);

    /**
     * 根据主键查询实体
     *
     * @param
     * @return 实体
     */
    TbCfToicouponEntity queryObject(String toitableId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfToicouponEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfToicoupon 实体
     * @return 保存条数
     */
    int save(TbCfToicouponEntity tbCfToicoupon);

    /**
     * 根据主键更新实体
     *
     * @param tbCfToicoupon 实体
     * @return 更新条数
     */
    int update(TbCfToicouponEntity tbCfToicoupon);

    /**
     * 根据主键删除
     *
     * @param toitableId
     * @return 删除条数
     */
    int delete(String toitableId);

    /**
     * 根据主键批量删除
     *
     * @param toitableIds
     * @return 删除条数
     */
    int deleteBatch(String[] toitableIds);

    /**
     * 保存用户的优惠券
     *
     * @param tbCfCouponIssue
     * @param tbCfToiCoupon
     * @param userId
     * @return
     */

}
