package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfFeedbackEntity;
import com.diaoyun.zion.master.base.Result;

import java.util.List;
import java.util.Map;

/**
 * 反馈情况Service接口
 *
 * @author lipengjun
 * @date 2019-09-05 16:51:07
 */
public interface TbCfFeedbackService {

    /**
     * 根据主键查询实体
     *
     * @param feedbackId 主键
     * @return 实体
     */
    TbCfFeedbackEntity queryObject(String feedbackId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfFeedbackEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfFeedback 实体
     * @return 保存条数
     */
    int save(TbCfFeedbackEntity tbCfFeedback);

    /**
     * 根据主键更新实体
     *
     * @param tbCfFeedback 实体
     * @return 更新条数
     */
    int update(TbCfFeedbackEntity tbCfFeedback);

    /**
     * 根据主键删除
     *
     * @param feedbackId
     * @return 删除条数
     */
    int delete(String feedbackId);

    /**
     * 根据主键批量删除
     *
     * @param feedbackIds
     * @return 删除条数
     */
    int deleteBatch(String[] feedbackIds);

    /**
     * 获取反馈问题
     * @return
     */
    Result getFeedbackList();
}
