package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfCouponCategoryEntity;

import java.util.List;
import java.util.Map;

/**
 * 优惠券类型表Service接口
 *
 * @author lipengjun
 * @date 2019-10-22 10:23:49
 */
public interface TbCfCouponCategoryService {

    /**
     * 根据主键查询实体
     *
     * @param
     * @return 实体
     */
    TbCfCouponCategoryEntity queryObject(String couponCategoryId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfCouponCategoryEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfCouponCategory 实体
     * @return 保存条数
     */
    int save(TbCfCouponCategoryEntity tbCfCouponCategory);

    /**
     * 根据主键更新实体
     *
     * @param tbCfCouponCategory 实体
     * @return 更新条数
     */
    int update(TbCfCouponCategoryEntity tbCfCouponCategory);

    /**
     * 根据主键删除
     *
     * @param couponCategoryId
     * @return 删除条数
     */
    int delete(String couponCategoryId);

    /**
     * 根据主键批量删除
     *
     * @param couponCategoryIds
     * @return 删除条数
     */
    int deleteBatch(String[] couponCategoryIds);

    /**
     * 根据优惠券类型id查询
     * @param categoryId
     * @return
     */
    List<TbCfCouponCategoryEntity> queryByCouponCategoryId(String categoryId);
}
