package com.diaoyun.zion.chinafrica.service;

import com.diaoyun.zion.chinafrica.entity.TbCfCategoryHsEntity;

import java.util.List;
import java.util.Map;

/**
 * 商品报关品名表（从第三方合作商拿过来的）Service接口
 *
 * @author lipengjun
 * @date 2019-08-30 09:54:02
 */
public interface TbCfCategoryHsService {

    /**
     * 根据主键查询实体
     *
     * @param categoryId 主键
     * @return 实体
     */
    TbCfCategoryHsEntity queryObject(String categoryId);

    /**
     * 分页查询
     *
     * @param map 参数
     * @return list
     */
    List<TbCfCategoryHsEntity> queryList(Map<String, Object> map);

    /**
     * 分页统计总数
     *
     * @param map 参数
     * @return 总数
     */
    int queryTotal(Map<String, Object> map);

    /**
     * 保存实体
     *
     * @param tbCfCategoryHs 实体
     * @return 保存条数
     */
    int save(TbCfCategoryHsEntity tbCfCategoryHs);

    /**
     * 根据主键更新实体
     *
     * @param tbCfCategoryHs 实体
     * @return 更新条数
     */
    int update(TbCfCategoryHsEntity tbCfCategoryHs);

    /**
     * 根据主键删除
     *
     * @param categoryId
     * @return 删除条数
     */
    int delete(String categoryId);

    /**
     * 根据主键批量删除
     *
     * @param categoryIds
     * @return 删除条数
     */
    int deleteBatch(String[] categoryIds);
}
