package com.diaoyun.zion.chinafrica.dao;


import com.diaoyun.zion.chinafrica.entity.TbCfTakeCouponEntity;
import com.diaoyun.zion.master.dao.BaseDao;

/**
 * 用户领取优惠券列表Dao
 *
 * @author lipengjun
 * @date 2019-08-29 11:33:33
 */
public interface TbCfTakeCouponDao extends BaseDao<TbCfTakeCouponEntity> {

    /**
     * 判断用户是否已经领取了优惠券
     * @param userId
     * @param couponId
     * @return takeId
     */
    String queryTakeByCouponId(String userId,String couponId);

    /**
     * 统计已领取数量
     * @param couponId
     * @return
     */
    Integer queryTakeCount(String couponId);

    /**
     * 更改使用状态
     * @param userId
     * @param couponId
     * @param enableFlag
     * @return
     */
    int updateEnableFlag(String userId, String couponId, Integer enableFlag);
}
