package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.entity.CouponItem;
import com.diaoyun.zion.chinafrica.entity.TbCfCouponEntity;
import com.diaoyun.zion.chinafrica.service.TbCfCouponService;
import com.diaoyun.zion.chinafrica.service.TbCfToiCouponService;
import com.diaoyun.zion.chinafrica.vo.UserCouponVo;
import com.diaoyun.zion.master.base.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 优惠券表Controller
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Api(tags = "优惠券")
@RestController
@RequestMapping("/coupon")
public class TbCfCouponController {
    @Autowired
    private TbCfCouponService tbCfCouponService;
    @Autowired
    private TbCfToiCouponService tbCfToiCouponService;
    @ApiOperation("领取优惠券")
    @GetMapping("/take/{couponId}")
    public Result<TbCfCouponEntity> takeCoupon(@ApiParam("优惠券Id")@PathVariable("couponId")String couponId) {
        return tbCfCouponService.takeCoupon(couponId);
    }
    @ApiOperation("获取用户所有优惠券")
    @GetMapping
    public Result<UserCouponVo> getUserCoupons() {
        return tbCfCouponService.getUserCoupons();
    }

    @ApiOperation("获取优惠券详情")
    @GetMapping("/{couponId}")
    public Result<TbCfCouponEntity> queryCouponDetail(@ApiParam("优惠券Id")@PathVariable("couponId")String couponId) {
        return tbCfCouponService.queryCouponDetail(couponId);
    }
    @ApiOperation("根据用户Id查询优惠券")
    @GetMapping("/queryCouponByUserId/{userId}")
    public Result<CouponItem> queryCouponByUserId(@ApiParam("用户Id")@PathVariable("userId") String userId) {
        return tbCfToiCouponService.queryCouponByUserId(userId);
    }
 /*   @ApiOperation("更改优惠券状态")
    @GetMapping("/changCouponStatus/{userId}/{couponId}")
    public Result changCouponStatus(@ApiParam("用户Id")@PathVariable("userId") String userId,@ApiParam("优惠券Id")@PathVariable("couponId") String couponId){
        return tbCfIssueCouponService.changeCouponStatus(userId,couponId);
    }*/
}
