package com.diaoyun.zion.chinafrica.controller;

import com.diaoyun.zion.chinafrica.service.TbCfAddressService;
import com.diaoyun.zion.chinafrica.vo.TbCfAddressVo;
import com.diaoyun.zion.master.base.Result;
import com.diaoyun.zion.master.enums.ResultCodeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 地址相关api
 *
 * @author G
 */
@Api(tags = "地址相关")
@RestController
@RequestMapping("/address")
public class TbCfAddressController {
    @Autowired
    private TbCfAddressService tbCfAddressService;

    @ApiOperation("获取用户所有地址")
    @GetMapping
    public Result<List<TbCfAddressVo>> getUserInfoList() {
        List<TbCfAddressVo> tbCfAddressVoList=tbCfAddressService.getUserInfoList();
        return new Result<>(tbCfAddressVoList);
    }


    @ApiOperation("增加用户地址信息")
    @PostMapping
    public Result addUserInfo(@ApiParam("地址信息") @RequestBody TbCfAddressVo tbCfAddressVo) {
        tbCfAddressVo=tbCfAddressService.saveAddress(tbCfAddressVo);
        return new Result<>(tbCfAddressVo);
    }

    @ApiOperation("修改用户地址信息")
    @PutMapping(value="/{addressId}")
    public Result updateUserInfo(@ApiParam("地址id") @PathVariable("addressId")String addressId, @ApiParam("地址信息") @RequestBody TbCfAddressVo tbCfAddressVo) {
        tbCfAddressVo.setAddressId(addressId);
        tbCfAddressVo=tbCfAddressService.updateAddress(tbCfAddressVo);
        return new Result<>(tbCfAddressVo);
    }

    @ApiOperation("删除用户地址信息")
    @DeleteMapping(value="/{addressId}")
    public Result deleteUserInfo(@ApiParam("地址id") @PathVariable("addressId")String addressId) {
        int res=tbCfAddressService.delete(addressId);
        if(res>0) {
            return new Result<>(ResultCodeEnum.SUCCESS.getDesc());
        } else {
            return new Result<>().setCode(ResultCodeEnum.ERROR.getCode()).setMessage(ResultCodeEnum.ERROR.getDesc());
        }

    }

    @ApiOperation("设置为默认地址")
    @PutMapping(value="/default/{addressId}")
    public Result configDefaultAddress(@ApiParam("地址id") @PathVariable("addressId")String addressId) {
        int res=tbCfAddressService.configDefaultAddress(addressId);
        if(res>0) {
            return new Result<>(ResultCodeEnum.SUCCESS.getDesc());
        } else {
            return new Result<>().setCode(ResultCodeEnum.ERROR.getCode()).setMessage(ResultCodeEnum.ERROR.getDesc());
        }
    }

    @ApiOperation("获取用户默认地址")
    @GetMapping(value="/default")
    public Result getDefaultAddress() {
        return tbCfAddressService.getDefaultAddress();
    }

    @ApiOperation("根据地址id获取详细地址")
    @GetMapping(value="/{addressId}")
    public Result getAddressDetailById(@ApiParam("地址id") @PathVariable("addressId")String addressId) {
        return tbCfAddressService.getAddressDetailById(addressId);
    }

}
