package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * Stradivarius 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("stradivariusSpider")
public class StradivariusSpider implements IItemSpider {

    /**
     * Stradivarius 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws URISyntaxException, IOException, ExecutionException, InterruptedException, TimeoutException {
        String[] spilt = targetUrl.split("p");
        spilt = spilt[2].split(".html");
        String pId = spilt[0];
        targetUrl = "https://www.stradivarius.cn/itxrest/2/catalog/store/55009578/50331061/category/0/product/" + pId + "/detail";
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.STRADIVARIUS.getValue());
        JSONObject resultObj = JSONObject.fromObject(content);
        ProductResponse productResponse = formatProductResponse(resultObj, pId);
        resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     * @param dataMap 主要的 Json 数据
     * @param pId 商品 id
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(JSONObject dataMap, String pId) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 取 detail 节点对象
        JSONObject detailObj = dataMap.getJSONObject("detail");

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setItemId(pId);
        itemInfo.setShopName("Stradivarius");
        itemInfo.setShopUrl("https://www.stradivarius.cn/");
        itemInfo.setTitle(detailObj.getString("description"));
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////
        // 取 colors 节点数组
        JSONArray colorsArr = detailObj.getJSONArray("colors");
        for (int i = 0; i < colorsArr.size(); i++) {
            JSONObject colorsObj = colorsArr.getJSONObject(i);

            String colorNo = colorsObj.getString("id");
            String color = colorsObj.getString("name");
            String imgUrl = "https://static.stradivarius.cn/5/photos3"
                    + colorsObj.getJSONObject("image").getString("url")
                    +"_6_1_4.jpg?t="
                    + colorsObj.getJSONObject("image").getString("timestamp");

            if (i == 0) {
                itemInfo.setPic(imgUrl);
            }


            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imgUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////

            ///////////////////////// 获取商品尺码属性 ///////////////////////////////////////////////////////
            // 取每个 colors 的 sizes 对象数组
            JSONArray sizesArr = colorsObj.getJSONArray("sizes");

            for (int j = 0; j < sizesArr.size(); j++) {
                JSONObject sizesObj = sizesArr.getJSONObject(j);

                String sizeNo = sizesObj.getString("sku");
                String size = sizesObj.getString("name");

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END///////////////////////////////////////////////////

                //////////////////////////////////// 获取库存与原始价 ////////////////////////////////////////////
                // 设置库存id
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }

                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);

                // 获取商品的原始价
                String fullPrice = sizesObj.getString("price");
                BigDecimal priceOld = new BigDecimal(fullPrice);
                BigDecimal div = new BigDecimal("100");
                fullPrice = priceOld.divide(div, 2, BigDecimal.ROUND_DOWN).toString();
                // TODO 转换汇率，目前商品单位是人民币
                String originalFullPrice = exchangeRate(fullPrice);

                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setPrice(originalFullPrice);
                originalPrice.setSkuStr(skuStr);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(originalFullPrice);
                productResponse.setSalePrice(originalFullPrice + "-" + originalFullPrice);
                //////////////////////////////////// 获取库存与原始价 END///////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Stradivarius");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}
