package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import com.diaoyun.zion.master.util.SpiderUtil;
import net.sf.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * LouisVuitton(路易威登LV) 数据爬虫
 *
 * @author 爱酱油不爱醋
 */
@Component("louisVuittonSpider")
public class LouisVuittonSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * LouisVuitton(路易威登LV) 数据爬虫
     *
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.FENDI.getValue());
        ProductResponse productResponse = formatProductResponse(content);
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     *
     * @param content 主要的网页内容
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(String content) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        Document document = Jsoup.parse(content);

        Elements skuEle = document.select("div[id=infoProductBlock]");
        // 获取商品的 id
        String pId = skuEle.select("span[class=sku]").text();
        // 获取该商品的一张图片
        String imageUrl = document.select("li[id=productSheetSlideshowItem_0]").select("img").attr("src");
        String[] spilt = imageUrl.split("[?]");
        imageUrl = spilt[0];

        // 获取价格
        String fullPrice = document.select("div[class=productAction]").select("span[class=priceValuePurchaseLayer]").text();
        fullPrice = SpiderUtil.retainNumber(fullPrice);
        fullPrice = exchangeRate(fullPrice);

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName("LouisVuitton");
        itemInfo.setShopUrl("https://inside.chanel.com/");
        itemInfo.setItemId(pId);
        itemInfo.setTitle(skuEle.select("h1[class=productName]").text());
        itemInfo.setPic(imageUrl);
        //////////////////////////////////// 获取商品基本信息End /////////////////////////

        ///////////////////////// 获取商品颜色属性 ////////////////////////////////////////////////////////////////

        // TODO 此处还需要加颜色判断

        String colorNo = pId;
        ProductProp productPropColor = new ProductProp();
        productPropColor.setPropId(pId);
        productPropColor.setPropName(pId);
        productPropColor.setImage(imageUrl);
        propSet.add(productPropColor);
        if (productPropSet.get("颜色") == null) {
            productPropSet.put("颜色", propSet);
        } else {
            Set<ProductProp> oldPropSet = productPropSet.get("颜色");
            propSet.addAll(oldPropSet);
            productPropSet.put("颜色", propSet);
        }
        ///////////////////////// 获取商品颜色属性End ////////////////////////////////////////////////////////////////

        Elements sizeEle = skuEle.select("div[class=topPanelContent sizesPanel js-tracking]").select("ul[id=size]").select("li");
        for (Element element : sizeEle) {

            String sizeNo = element.attr("data-ona");
            String size = element.select("span").text();

            ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////
            ProductProp productPropSize = new ProductProp();

            productPropSize.setPropId(sizeNo);
            productPropSize.setPropName(size);
            sizePropSet.add(productPropSize);
            if (productPropSet.get("尺码") == null) {
                productPropSet.put("尺码", sizePropSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                sizePropSet.addAll(oldPropSet);
                productPropSet.put("尺码", sizePropSet);
            }
            ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////

            //////////////////////////////////// 获取库存/////////////////////////////////////////
            // 设置 skuStr
            String skuStr = ";" + colorNo + ";" + sizeNo + ";";

            if (productSkuStockList == null) {
                productSkuStockList = new ArrayList<>();
            }
            ProductSkuStock productSkuStock = new ProductSkuStock();
            productSkuStock.setSellableQuantity(999);
            productSkuStock.setSkuStr(skuStr);
            productSkuStockList.add(productSkuStock);
            dynStock.setProductSkuStockList(productSkuStockList);

            //////////////////////////////////// 获取库存 END/////////////////////////////////////////

            //////////////////////////////////// 获取原始价 //////////////////////////////////
            OriginalPrice originalPrice = new OriginalPrice();

            originalPrice.setSkuStr(skuStr);
            originalPrice.setPrice(fullPrice);
            originalPriceList.add(originalPrice);

            productResponse.setPrice(fullPrice);
            productResponse.setSalePrice(fullPrice + "-" + fullPrice);
            //////////////////////////////////// 获取原始价 END //////////////////////////////////
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("LouisVuitton");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }

}