package com.diaoyun.zion.chinafrica.bis.impl;

import com.diaoyun.zion.chinafrica.bis.IItemSpider;
import com.diaoyun.zion.chinafrica.enums.PlatformEnum;
import com.diaoyun.zion.chinafrica.vo.*;
import com.diaoyun.zion.master.util.HttpClientUtil;
import com.diaoyun.zion.master.util.JsoupUtil;
import com.diaoyun.zion.master.util.TranslateHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

import static com.diaoyun.zion.master.util.SpiderUtil.exchangeRate;

/**
 * Levi(李维斯)
 *
 * @author 爱酱油不爱醋
 */
@Component("leviSpider")
public class LeviSpider implements IItemSpider {
    private static Logger logger = LoggerFactory.getLogger(PullandbearSpider.class);

    /**
     * Levi(李维斯) 数据爬虫
     * @param targetUrl 接收的商品详情路径
     * @return 格式化与翻译后的 Json 数据
     */
    @Override
    public JSONObject captureItem(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException, TimeoutException {
        String content = HttpClientUtil.getContentByUrl(targetUrl, PlatformEnum.LEVI.getValue());
        JSONObject dataMap = JsoupUtil.getItemDetailByName(content, "window.__INITIAL_STATE__");
        ProductResponse productResponse = formatProductResponse(dataMap);
        if (productResponse.getItemInfo() == null) {
            JSONObject notSpiderObj = new JSONObject();
            notSpiderObj.put("message", "未找到此网站的数据爬虫！");
            return notSpiderObj;
        }
        JSONObject resultObj = JSONObject.fromObject(productResponse);
        TranslateHelper.translateProductResponse(resultObj);
        return resultObj;
    }

    /**
     * 格式化返回数据
     * @param dataMap 主要的Json数据
     * @return 格式化后的数据
     */
    private ProductResponse formatProductResponse(JSONObject dataMap) {
        // 声明封装类
        ProductResponse productResponse = new ProductResponse();
        // 含有商品的属性，设置为true
        productResponse.setPropFlag(true);
        // 库存信息，如果没有可使用的库存信息则默认为999
        DynStock dynStock = new DynStock();
        dynStock.setSellableQuantity(9999);
        List<ProductSkuStock> productSkuStockList = dynStock.getProductSkuStockList();
        // 产品的原始价与优惠价
        List<OriginalPrice> originalPriceList = new ArrayList<>();
        List<ProductPromotion> promotionList = new ArrayList<>();
        // 商品的属性，常用的商品属性为颜色与尺码
        Map<String, Set<ProductProp>> productPropSet = new HashMap<>(16);
        Set<ProductProp> propSet = new HashSet<>(16);
        Set<ProductProp> sizePropSet = new HashSet<>(16);
        productResponse.setStockFlag(true);
        // 商品的基本属性
        ItemInfo itemInfo = new ItemInfo();

        // 取 product 下的 details 节点对象
        JSONObject detailsObj = dataMap.getJSONObject("product").getJSONObject("details");

        // 判断如果不是商品详情页读取数据，则返回
        if (!detailsObj.containsKey("code")) {
            return productResponse;
        }

        // 获取商品的原始价
        String fullPrice = detailsObj.getJSONObject("salePrice").getString("amount");
        // TODO 转换汇率，目前商品单位是人民币
        fullPrice = exchangeRate(fullPrice);

        //////////////////////////////////// 获取商品基本信息 ////////////////////////////
        itemInfo.setShopName("Levi");
        itemInfo.setShopUrl("https://www.levi.com");
        itemInfo.setItemId(detailsObj.getString("code"));
        itemInfo.setTitle(detailsObj.getString("title"));
        //////////////////////////////////// 获取商品基本信息(图片下取)End /////////////////////////

        JSONArray values_0_Arr = detailsObj.getJSONArray("options").getJSONObject(0).getJSONArray("values");
        JSONArray values_1_Arr = detailsObj.getJSONArray("options").getJSONObject(1).getJSONArray("values");

        //////////////////////////////////// 获取商品颜色属性 ////////////////////////////////////////////
        // 取 options 的0位的 value 节点数组
        for (int i = 0; i < values_0_Arr.size(); i++) {
            JSONObject values_0_Obj = values_0_Arr.getJSONObject(i);

            String colorNo = values_0_Obj.getString("code");
            String color = values_0_Obj.getString("displayName");
            String imageUrl = values_0_Obj.getJSONArray("images").getJSONObject(0).getString("url");

            if (i == 0) {
                itemInfo.setPic(imageUrl);
            }

            ProductProp productPropColor = new ProductProp();
            productPropColor.setPropId(colorNo);
            productPropColor.setPropName(color);
            productPropColor.setImage(imageUrl);
            propSet.add(productPropColor);
            if (productPropSet.get("颜色") == null) {
                productPropSet.put("颜色", propSet);
            } else {
                Set<ProductProp> oldPropSet = productPropSet.get("颜色");
                propSet.addAll(oldPropSet);
                productPropSet.put("颜色", propSet);
            }
            //////////////////////////////////// 获取商品颜色属性 END ////////////////////////////////////////////

            ///////////////////////// 获取商品尺码属性 ////////////////////////////////////////////////////////////////
            // 取 options 的 1 位的 value 节点数组
            for (int j = 0; j < values_1_Arr.size(); j++) {
                JSONObject values_1_Obj = values_1_Arr.getJSONObject(j);

                String sizeNo = values_1_Obj.getString("code");
                String size = values_1_Obj.getString("displayName");

                ProductProp productPropSize = new ProductProp();
                productPropSize.setPropId(sizeNo);
                productPropSize.setPropName(size);
                sizePropSet.add(productPropSize);
                if (productPropSet.get("尺码") == null) {
                    productPropSet.put("尺码", sizePropSet);
                } else {
                    Set<ProductProp> oldPropSet = productPropSet.get("尺码");
                    sizePropSet.addAll(oldPropSet);
                    productPropSet.put("尺码", sizePropSet);
                }
                ///////////////////////// 获取商品尺码属性 END/////////////////////////////////////////////////////

                // 设置 skuStr
                String skuStr = ";" + colorNo + ";" + sizeNo + ";";

                //////////////////////////////////// 获取库存 ////////////////////////////////////////////
                if (productSkuStockList == null) {
                    productSkuStockList = new ArrayList<>();
                }
                ProductSkuStock productSkuStock = new ProductSkuStock();
                productSkuStock.setSkuStr(skuStr);
                productSkuStock.setSellableQuantity(999);
                productSkuStockList.add(productSkuStock);
                dynStock.setProductSkuStockList(productSkuStockList);
                //////////////////////////////////// 获取库存 END/////////////////////////////////////////

                //////////////////////////////////// 获取原始价 //////////////////////////////////
                OriginalPrice originalPrice = new OriginalPrice();
                originalPrice.setSkuStr(skuStr);
                originalPrice.setPrice(fullPrice);
                originalPriceList.add(originalPrice);

                productResponse.setPrice(fullPrice);
                productResponse.setSalePrice(fullPrice + "-" + fullPrice);
                //////////////////////////////////// 获取原始价 END//////////////////////////////////
            }
        }

        productResponse.setProductPropSet(productPropSet);
        productResponse.setPlatform("Levi");
        productResponse.setPromotionList(promotionList);
        productResponse.setOriginalPriceList(originalPriceList);
        productResponse.setItemInfo(itemInfo);
        productResponse.setDynStock(dynStock);
        return productResponse;
    }
}